/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.mrm.plugin;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.mrm.plugin.AbstractStartMojo;
import org.codehaus.mojo.mrm.plugin.ArtifactStoreFactory;
import org.codehaus.mojo.mrm.plugin.FactoryHelper;
import org.codehaus.mojo.mrm.plugin.FileSystemServer;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, requiresProject=false, threadSafe=true)
public class StartMojo
extends AbstractStartMojo {
    @Parameter(property="mrm.propertyName", defaultValue="mrm.repository.url")
    private String propertyName;

    @Inject
    public StartMojo(FactoryHelper factoryHelper, @Named(value="proxyRepo") ArtifactStoreFactory proxyRepo) {
        super(factoryHelper, proxyRepo);
    }

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        FileSystemServer mrm = this.createFileSystemServer(this.createArtifactStore());
        this.getLog().info((CharSequence)"Starting Mock Repository Manager");
        mrm.ensureStarted();
        String url = mrm.getUrl();
        this.getLog().info((CharSequence)("Mock Repository Manager " + url + " is started."));
        if (!StringUtils.isEmpty((String)this.propertyName)) {
            this.getLog().info((CharSequence)("Setting property '" + this.propertyName + "' to '" + url + "'."));
            this.project.getProperties().setProperty(this.propertyName, url);
        }
        Map pluginContext = this.session.getPluginContext(this.pluginDescriptor, this.project);
        pluginContext.put(StartMojo.getFileSystemServerKey(this.getMojoExecution()), mrm);
    }

    protected static String getFileSystemServerKey(MojoExecution mojoExecution) {
        return FileSystemServer.class.getName() + "@" + mojoExecution.getExecutionId();
    }
}

