/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.pluginsupport.ant;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.codehaus.mojo.pluginsupport.MojoSupport;
import org.codehaus.mojo.pluginsupport.ant.MavenAntLoggerAdapter;

public abstract class AntMojoSupport
extends MojoSupport {
    protected Project ant;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected void init() throws MojoExecutionException, MojoFailureException {
        super.init();
        this.ant = new Project();
        this.ant.setBaseDir(this.getProject().getBasedir());
        this.initAntLogger(this.ant);
        this.ant.init();
        this.inheritProperties();
    }

    protected void initAntLogger(Project ant) {
        MavenAntLoggerAdapter antLogger = new MavenAntLoggerAdapter(this.log);
        antLogger.setEmacsMode(true);
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        if (this.log.isDebugEnabled()) {
            antLogger.setMessageOutputLevel(3);
        } else {
            antLogger.setMessageOutputLevel(2);
        }
        ant.addBuildListener((BuildListener)antLogger);
    }

    protected void setProperty(String name, Object value) {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        String valueAsString = String.valueOf(value);
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Setting property: " + name + "=" + valueAsString));
        }
        Property prop = (Property)this.createTask("property");
        prop.setName(name);
        prop.setValue(valueAsString);
        prop.execute();
    }

    protected void setSystemProperty(Java java, String name, String value) {
        if (!$assertionsDisabled && java == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        Environment.Variable var = new Environment.Variable();
        var.setKey(name);
        var.setValue(value);
        java.addSysproperty(var);
    }

    protected void setSystemProperty(Java java, String name, File value) {
        if (!$assertionsDisabled && java == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && value == null) {
            throw new AssertionError();
        }
        Environment.Variable var = new Environment.Variable();
        var.setKey(name);
        var.setFile(value);
        java.addSysproperty(var);
    }

    protected void inheritProperties() {
        Properties props = this.getProject().getProperties();
        Iterator iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            String value = String.valueOf(props.get(name));
            this.setProperty(name, value);
        }
        this.setProperty("pom.basedir", this.getProject().getBasedir());
    }

    protected FileSet createFileSet() {
        FileSet set = new FileSet();
        set.setProject(this.ant);
        return set;
    }

    protected Task createTask(String name) throws BuildException {
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        return this.ant.createTask(name);
    }

    protected void mkdir(File dir) {
        if (!$assertionsDisabled && dir == null) {
            throw new AssertionError();
        }
        Mkdir mkdir = (Mkdir)this.createTask("mkdir");
        mkdir.setDir(dir);
        mkdir.execute();
    }

    static {
        $assertionsDisabled = !AntMojoSupport.class.desiredAssertionStatus();
    }
}

