/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class DisplayPropertyUpdatesMojo
extends AbstractVersionsUpdaterMojo {
    private static final int INFO_PAD_SIZE = 68;
    private Property[] properties;
    private String includeProperties = null;
    private String excludeProperties = null;
    private Boolean autoLinkItems;

    public void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> current = new ArrayList<String>();
        ArrayList<String> updates = new ArrayList<String>();
        Map propertyVersions = this.getHelper().getVersionPropertiesMap(this.getProject(), this.properties, this.includeProperties, this.excludeProperties, !Boolean.FALSE.equals(this.autoLinkItems));
        Iterator i = propertyVersions.entrySet().iterator();
        while (i.hasNext()) {
            StringBuffer buf;
            Map.Entry entry = i.next();
            Property property = (Property)entry.getKey();
            PropertyVersions version = (PropertyVersions)entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null) continue;
            ArtifactVersion winner = version.getNewestVersion(currentVersion, property, this.allowSnapshots, this.reactorProjects, this.getHelper());
            if (winner != null && !currentVersion.equals(winner.toString())) {
                buf = new StringBuffer();
                buf.append("${");
                buf.append(property.getName());
                buf.append("} ");
                String newVersion = winner.toString();
                int padding = 68 - currentVersion.length() - newVersion.length() - 4;
                while (buf.length() < padding) {
                    buf.append('.');
                }
                buf.append(' ');
                buf.append(currentVersion);
                buf.append(" -> ");
                buf.append(newVersion);
                updates.add(buf.toString());
                continue;
            }
            buf = new StringBuffer();
            buf.append("${");
            buf.append(property.getName());
            buf.append("} ");
            int padding = 68 - currentVersion.length();
            while (buf.length() < padding) {
                buf.append('.');
            }
            buf.append(' ');
            buf.append(currentVersion);
            current.add(buf.toString());
        }
        this.getLog().info((CharSequence)"");
        if (!current.isEmpty()) {
            this.getLog().info((CharSequence)"The following version properties are referencing the newest available version:");
            i = current.iterator();
            while (i.hasNext()) {
                this.getLog().info((CharSequence)("  " + i.next()));
            }
        }
        if (updates.isEmpty() && current.isEmpty()) {
            this.getLog().info((CharSequence)"This project does not have any properties associated with versions.");
        } else if (updates.isEmpty()) {
            this.getLog().info((CharSequence)"All version properties are referencing the newest version available.");
        }
        if (!updates.isEmpty()) {
            this.getLog().info((CharSequence)"The following version property updates are available:");
            i = updates.iterator();
            while (i.hasNext()) {
                this.getLog().info((CharSequence)("  " + i.next()));
            }
        }
        this.getLog().info((CharSequence)"");
    }

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
    }
}

