/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Locale;
import java.util.TreeMap;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.mojo.versions.AbstractVersionsReport;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.PropertyUpdatesRenderer;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.utils.PropertyComparator;

@Mojo(name="property-updates-report", requiresProject=true, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class PropertyUpdatesReport
extends AbstractVersionsReport {
    @Parameter
    private Property[] properties;
    @Parameter(property="includeProperties")
    private String includeProperties = null;
    @Parameter(property="excludeProperties")
    private String excludeProperties = null;
    @Parameter(property="autoLinkItems", defaultValue="true")
    private boolean autoLinkItems;

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return this.haveBuildProperties();
    }

    private boolean haveBuildProperties() {
        return this.getProject().getProperties() != null && !this.getProject().getProperties().isEmpty();
    }

    @Override
    protected void doGenerateReport(Locale locale, Sink sink) throws MavenReportException {
        TreeMap<Property, PropertyVersions> updateSet = new TreeMap<Property, PropertyVersions>(new PropertyComparator());
        try {
            updateSet.putAll(this.getHelper().getVersionPropertiesMap(this.getProject(), this.properties, this.includeProperties, this.excludeProperties, this.autoLinkItems));
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException(e.getMessage(), (Exception)((Object)e));
        }
        PropertyUpdatesRenderer renderer = new PropertyUpdatesRenderer(sink, this.getI18n(), this.getOutputName(), locale, updateSet);
        renderer.render();
    }

    public String getOutputName() {
        return "property-updates-report";
    }
}

