/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.codehaus.mojo.versions.api.AbstractVersionDetails;
import org.codehaus.mojo.versions.api.ArtifactVersionsCache;
import org.codehaus.mojo.versions.api.PluginUpdatesDetails;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.reporting.PluginOverviewStats;
import org.codehaus.mojo.versions.reporting.model.PluginInfo;
import org.codehaus.mojo.versions.reporting.model.PluginReportSummary;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesModel;
import org.codehaus.mojo.versions.reporting.model.PluginUpdatesReport;
import org.codehaus.mojo.versions.reporting.model.io.xpp3.PluginUpdatesReportXpp3Writer;
import org.codehaus.mojo.versions.reporting.util.ReportRenderer;
import org.codehaus.mojo.versions.xml.CommonXmlReportRendererUtils;

public class PluginUpdatesXmlReportRenderer
implements ReportRenderer {
    private final PluginUpdatesModel model;
    private final Path outputFile;
    private final ArtifactVersionsCache newestUpdateCache = new ArtifactVersionsCache(AbstractVersionDetails::getNewestUpdate);
    private final boolean allowSnapshots;

    public PluginUpdatesXmlReportRenderer(PluginUpdatesModel model, Path outputFile, boolean allowSnapshots) {
        this.model = model;
        this.outputFile = outputFile;
        this.allowSnapshots = allowSnapshots;
    }

    public String getTitle() {
        return "Plugin updates";
    }

    @Override
    public boolean isAllowSnapshots() {
        return this.allowSnapshots;
    }

    public void render() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            new PluginUpdatesReportXpp3Writer().write((Writer)writer, new PluginUpdatesReport(){
                {
                    this.setSummary(new PluginReportSummary(){
                        {
                            PluginOverviewStats overviewStats = (PluginOverviewStats)PluginOverviewStats.fromUpdates(PluginUpdatesXmlReportRenderer.this.model.getAllUpdates().values(), PluginUpdatesXmlReportRenderer.this.newestUpdateCache, PluginUpdatesXmlReportRenderer.this.isAllowSnapshots());
                            this.setUsingLastVersion(String.valueOf(overviewStats.getUpToDate()));
                            this.setNextVersionAvailable(String.valueOf(overviewStats.getAny()));
                            this.setNextIncrementalAvailable(String.valueOf(overviewStats.getIncremental()));
                            this.setNextMinorAvailable(String.valueOf(overviewStats.getMinor()));
                            this.setNextMajorAvailable(String.valueOf(overviewStats.getMajor()));
                            this.setDependencyUpdates(String.valueOf(overviewStats.getDependencies()));
                        }
                    });
                    this.setPluginManagements(PluginUpdatesXmlReportRenderer.createPluginInfo(PluginUpdatesXmlReportRenderer.this.model.getArtifactManagementUpdates(), PluginUpdatesXmlReportRenderer.this.isAllowSnapshots()));
                    this.setPlugins(PluginUpdatesXmlReportRenderer.createPluginInfo(PluginUpdatesXmlReportRenderer.this.model.getArtifactUpdates(), PluginUpdatesXmlReportRenderer.this.isAllowSnapshots()));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<PluginInfo> createPluginInfo(Map<Dependency, PluginUpdatesDetails> versions, boolean allowSnapshots) {
        return versions.entrySet().stream().map(e -> new PluginInfo((Map.Entry)e, allowSnapshots){
            final /* synthetic */ Map.Entry val$e;
            final /* synthetic */ boolean val$allowSnapshots;
            {
                this.val$e = entry;
                this.val$allowSnapshots = bl;
                this.setGroupId(((Dependency)this.val$e.getKey()).getGroupId());
                this.setArtifactId(((Dependency)this.val$e.getKey()).getArtifactId());
                this.setCurrentVersion(((Dependency)this.val$e.getKey()).getVersion());
                this.setScope(((Dependency)this.val$e.getKey()).getScope());
                this.setType(((Dependency)this.val$e.getKey()).getType());
                this.setClassifier(((Dependency)this.val$e.getKey()).getClassifier());
                Optional.ofNullable(((PluginUpdatesDetails)this.val$e.getValue()).getNewestUpdate(Optional.empty(), this.val$allowSnapshots)).map(Object::toString).ifPresent(arg_0 -> (this).setLastVersion(arg_0));
                CommonXmlReportRendererUtils.setSection((AbstractVersionDetails)this.val$e.getValue(), Segment.INCREMENTAL, arg_0 -> (this).setIncrementals(arg_0), this.val$allowSnapshots);
                CommonXmlReportRendererUtils.setSection((AbstractVersionDetails)this.val$e.getValue(), Segment.MINOR, arg_0 -> (this).setMinors(arg_0), this.val$allowSnapshots);
                CommonXmlReportRendererUtils.setSection((AbstractVersionDetails)this.val$e.getValue(), Segment.MAJOR, arg_0 -> (this).setMajors(arg_0), this.val$allowSnapshots);
                this.setStatus(CommonXmlReportRendererUtils.statusFor(this.getLastVersion(), this.getIncrementals(), this.getMinors()));
            }
        }).collect(Collectors.toList());
    }
}

