/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Extension;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.Segment;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.filtering.DependencyFilter;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;
import org.codehaus.mojo.versions.utils.CoreExtensionUtils;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.ExtensionBuilder;
import org.codehaus.mojo.versions.utils.ModelNode;
import org.codehaus.mojo.versions.utils.SegmentUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="display-extension-updates", aggregator=true, threadSafe=true)
public class DisplayExtensionUpdatesMojo
extends AbstractVersionsDisplayMojo {
    private static final int INFO_PAD_SIZE = 72;
    @Parameter(property="extensionIncludes", defaultValue="*")
    private List<String> extensionIncludes;
    @Parameter(property="extensionExcludes")
    private List<String> extensionExcludes;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates = true;
    @Parameter(property="processCoreExtensions", defaultValue="true")
    private boolean processCoreExtensions = true;
    @Parameter(property="processBuildExtensions", defaultValue="true")
    private boolean processBuildExtensions = true;
    @Parameter(property="interpolateProperties", defaultValue="true")
    protected boolean interpolateProperties = true;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;

    @Inject
    public DisplayExtensionUpdatesMojo(RepositorySystem repositorySystem, org.eclipse.aether.RepositorySystem aetherRepositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(repositorySystem, aetherRepositorySystem, wagonMap, changeRecorders);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Set dependencies;
        this.logInit();
        this.validateInput();
        if (!this.processCoreExtensions && !this.processBuildExtensions) {
            this.getLog().info((CharSequence)"Neither core nor build extensions are to be processed. Nothing to do.");
            return;
        }
        DependencyFilter includeFilter = DependencyFilter.parseFrom(this.extensionIncludes);
        DependencyFilter excludeFilter = DependencyFilter.parseFrom(this.extensionExcludes);
        try {
            Stream<Extension> extensions = this.processCoreExtensions ? CoreExtensionUtils.getCoreExtensions((MavenProject)this.project) : Stream.empty();
            if (this.processBuildExtensions) {
                if (!this.interpolateProperties) {
                    extensions = Stream.concat(extensions, PomHelper.getChildModels((MavenProject)this.session.getCurrentProject(), (Log)this.getLog()).values().stream().map(Model::getBuild).filter(Objects::nonNull).map(Build::getExtensions).map(Collection::stream).reduce(Stream::concat).orElse(Stream.empty()));
                } else {
                    List<ModelNode> rawModels = this.getRawModels();
                    for (ModelNode node : rawModels) {
                        if (node.getModel() == null) continue;
                        HashMap properties = new HashMap();
                        ModelNode p = node;
                        while (p != null) {
                            p.getModel().getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> properties.putIfAbsent(String.valueOf(key), String.valueOf(value))));
                            p = p.getParent().orElse(null);
                        }
                        extensions = Stream.concat(extensions, Optional.ofNullable(node.getModel().getBuild()).map(Build::getExtensions).orElse(Collections.emptyList()).stream().map(e -> ExtensionBuilder.newBuilder().withGroupId(PomHelper.evaluate((String)e.getGroupId(), (Map)properties)).withArtifactId(PomHelper.evaluate((String)e.getArtifactId(), (Map)properties)).withVersion(PomHelper.evaluate((String)e.getVersion(), (Map)properties)).build()));
                    }
                }
            }
            dependencies = extensions.map(e -> DependencyBuilder.newBuilder().withGroupId(e.getGroupId()).withArtifactId(e.getArtifactId()).withVersion(e.getVersion()).build()).filter(arg_0 -> ((DependencyFilter)includeFilter).matchersMatch(arg_0)).filter(arg_0 -> ((DependencyFilter)excludeFilter).matchersDontMatch(arg_0)).collect(Collectors.toSet());
        }
        catch (IOException | XmlPullParserException e2) {
            throw new MojoExecutionException(e2.getMessage());
        }
        if (dependencies.isEmpty()) {
            this.getLog().info((CharSequence)"Extensions set filtered by include- and exclude-filters is empty. Nothing to do.");
            return;
        }
        try {
            this.logUpdates(this.getHelper().lookupDependenciesUpdates(dependencies, true, true, this.allowSnapshots));
        }
        catch (VersionRetrievalException e3) {
            throw new MojoExecutionException(e3.getMessage(), (Exception)((Object)e3));
        }
    }

    private List<ModelNode> getRawModels() throws MojoFailureException {
        List rawModels;
        try {
            ModifiedPomXMLEventReader pomReader = this.newModifiedPomXER(new StringBuilder(new String(Files.readAllBytes(this.getProject().getFile().toPath()))), this.getProject().getFile().toPath().toString());
            ModelNode rootNode = new ModelNode(PomHelper.getRawModel((ModifiedPomXMLEventReader)pomReader), pomReader);
            rawModels = PomHelper.getRawModelTree((ModelNode)rootNode, (Log)this.getLog());
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        return rawModels;
    }

    private Optional<Segment> calculateUpdateScope() {
        return Optional.of(SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog()).map(Segment::minorTo).orElse(Segment.MAJOR));
    }

    private void logUpdates(Map<Dependency, ArtifactVersions> updates) {
        ArrayList withUpdates = new ArrayList();
        ArrayList<String> usingCurrent = new ArrayList<String>();
        for (ArtifactVersions versions : updates.values()) {
            ArrayList<String> t;
            ArtifactVersion latest;
            String current;
            String left = "  " + ArtifactUtils.versionlessKey((Artifact)versions.getArtifact()) + " ";
            if (versions.getCurrentVersion() != null) {
                current = versions.getCurrentVersion().toString();
                latest = versions.getNewestUpdateWithinSegment(this.calculateUpdateScope(), this.allowSnapshots);
            } else {
                ArtifactVersion newestVersion = versions.getNewestVersion(versions.getArtifact().getVersionRange(), this.allowSnapshots);
                current = versions.getArtifact().getVersionRange().toString();
                ArtifactVersion artifactVersion = latest = newestVersion == null ? null : versions.getNewestUpdateWithinSegment(newestVersion, this.calculateUpdateScope(), this.allowSnapshots);
                if (latest != null && ArtifactVersions.isVersionInRange((ArtifactVersion)latest, (VersionRange)versions.getArtifact().getVersionRange())) {
                    latest = null;
                }
            }
            String right = " " + (latest == null ? current : current + " -> " + latest);
            ArrayList<String> arrayList = t = latest == null ? usingCurrent : withUpdates;
            if (right.length() + left.length() + 3 > 72 + this.getOutputLineWidthOffset()) {
                t.add(left + "...");
                t.add(StringUtils.leftPad((String)right, (int)(72 + this.getOutputLineWidthOffset())));
                continue;
            }
            t.add(StringUtils.rightPad((String)left, (int)(72 + this.getOutputLineWidthOffset() - right.length()), (String)".") + right);
        }
        if (this.verbose) {
            if (usingCurrent.isEmpty()) {
                if (!withUpdates.isEmpty()) {
                    this.logLine(false, "No extensions are using the newest version.");
                    this.logLine(false, "");
                }
            } else {
                this.logLine(false, "The following extensions are using the newest version:");
                for (String s : usingCurrent) {
                    this.logLine(false, s);
                }
                this.logLine(false, "");
            }
        }
        if (withUpdates.isEmpty()) {
            if (!usingCurrent.isEmpty()) {
                this.logLine(false, "No extensions have newer versions.");
                this.logLine(false, "");
            }
        } else {
            this.logLine(false, "The following extensions have newer versions:");
            for (String withUpdate : withUpdates) {
                this.logLine(false, withUpdate);
            }
            this.logLine(false, "");
        }
    }

    @Override
    protected void update(ModifiedPomXMLEventReader pom) {
    }
}

