/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class LockSnapshotsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    public final Pattern matchSnapshotRegex = Pattern.compile("-SNAPSHOT");

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
            this.lockSnapshots(pom, this.getProject().getDependencyManagement().getDependencies());
        }
        if (this.isProcessingDependencies()) {
            this.lockSnapshots(pom, this.getProject().getDependencies());
        }
    }

    private void lockSnapshots(ModifiedPomXMLEventReader pom, Collection dependencies) throws XMLStreamException, MojoExecutionException {
        for (Dependency dep : dependencies) {
            String lockedVersion;
            String version;
            Matcher versionMatcher;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            if (!this.isIncluded(this.toArtifact(dep)) || !(versionMatcher = this.matchSnapshotRegex.matcher(version = dep.getVersion())).find() || versionMatcher.end() != version.length() || version.equals(lockedVersion = this.resolveSnapshotVersion(dep)) || !PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, lockedVersion)) continue;
            this.getLog().info((CharSequence)("Locked " + this.toString(dep) + " to version " + lockedVersion));
        }
    }

    private String resolveSnapshotVersion(Dependency dep) {
        this.getLog().debug((CharSequence)("Resolving snapshot version for dependency: " + dep));
        String lockedVersion = dep.getVersion();
        Artifact depArtifact = this.artifactFactory.createArtifact(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getScope(), dep.getType());
        try {
            this.resolver.resolve(depArtifact, this.getProject().getRemoteArtifactRepositories(), this.localRepository);
            lockedVersion = depArtifact.getVersion();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        return lockedVersion;
    }
}

