/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.application.service;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.application.service.ServiceDiscoverer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.Expand;
import org.codehaus.plexus.util.FileUtils;

public class DefaultServiceDiscoverer
extends AbstractLogEnabled
implements ServiceDiscoverer,
Initializable,
Contextualizable {
    private String serviceDirectory;
    private DefaultPlexusContainer container;

    public void initialize() throws InitializationException {
        this.getLogger().info("Services will be deployed in: '" + this.serviceDirectory + "'.");
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (DefaultPlexusContainer)context.get((Object)"plexus");
    }

    public void deploy(String name, String location) throws Exception {
        File jar = new File(location);
        this.deploy(name, jar, new File(this.serviceDirectory), new File(this.serviceDirectory));
    }

    private void deploy(String name, File jar, File services, File configurations) throws Exception {
        File serviceDir = new File(services, name);
        if (serviceDir.exists()) {
            this.getLogger().info("Removing old service.");
            FileUtils.deleteDirectory((File)serviceDir);
        }
        Expand ex = new Expand();
        ex.setDest(serviceDir);
        ex.setOverwrite(false);
        ex.setSrc(jar);
        try {
            this.getLogger().info("Extracting service jar '" + jar + "' to '" + serviceDir + "'.");
            ex.execute();
        }
        catch (Exception e) {
            this.getLogger().error("Could not extract " + serviceDir + ".", (Throwable)e);
        }
        File libDir = new File(serviceDir, "lib");
        if (!libDir.exists()) {
            throw new Exception("The service must have a /lib directory.");
        }
        this.addJars(libDir);
        File classesDir = new File(serviceDir, "classes");
        if (!classesDir.exists()) {
            throw new Exception("The service must have a /classesDir directory.");
        }
        this.addClasses(classesDir);
        this.container.discoverComponents(this.container.getCoreRealm());
        File serviceConfig = new File(configurations, name + ".xml");
        if (!serviceConfig.exists()) {
            File config = new File(new File(serviceDir, "conf"), "service.xml");
            if (config.exists()) {
                config.renameTo(serviceConfig);
                this.addConfiguration(serviceConfig);
            }
        } else {
            this.addConfiguration(serviceConfig);
        }
    }

    private void addConfiguration(File config) throws Exception {
        PlexusConfiguration serviceConfig = PlexusTools.buildConfiguration((String)config.getPath(), (Reader)new FileReader(config));
        this.startComponents(serviceConfig);
    }

    private void startComponents(PlexusConfiguration serviceConfig) throws PlexusConfigurationException, ComponentLookupException {
        PlexusConfiguration[] loadOnStartComponents = serviceConfig.getChild("load-on-start").getChildren("component");
        this.getLogger().debug("Found " + loadOnStartComponents.length + " components to load on start");
        for (int i = 0; i < loadOnStartComponents.length; ++i) {
            String role = loadOnStartComponents[i].getChild("role").getValue(null);
            String roleHint = loadOnStartComponents[i].getChild("role-hint").getValue();
            if (role == null) {
                throw new PlexusConfigurationException("Missing 'role' element from load-on-start.");
            }
            if (roleHint == null) {
                this.getLogger().info("Loading on start [role]: [" + role + "]");
            } else {
                this.getLogger().info("Loading on start [role,roleHint]: [" + role + "," + roleHint + "]");
            }
            if (roleHint == null) {
                this.container.lookup(role);
                continue;
            }
            this.container.lookup(role, roleHint);
        }
    }

    private void addJars(File jarDir) throws Exception {
        this.container.addJarRepository(jarDir);
    }

    private void addClasses(File classes) throws Exception {
        this.container.addJarResource(classes);
    }
}

