/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.net.URL;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.resource.loader.URLPlexusResource;

@Named(value="classloader")
@Singleton
public class ThreadContextClasspathResourceLoader
extends AbstractResourceLoader {
    public static final String ID = "classloader";

    @Override
    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        URL url;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            throw new ResourceNotFoundException(name);
        }
        if (name != null && name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((url = classLoader.getResource(name)) == null) {
            throw new ResourceNotFoundException(name);
        }
        return new URLPlexusResource(url);
    }
}

