/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.xmlrpc;

import java.net.InetAddress;
import java.net.Socket;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.xmlrpc.XmlRpcServer;

public class DefaultXmlRpcServer
extends AbstractLogEnabled
implements XmlRpcServer,
Startable {
    private int port;
    private String host;
    private WebServer webServer;

    public void start() {
    }

    public void stop() {
        if (this.webServer != null) {
            this.webServer.shutdown();
        }
        try {
            Socket interrupt = new Socket(InetAddress.getLocalHost(), this.port);
            interrupt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addListener(String host, int port, boolean secure) throws XmlRpcException {
        if (this.webServer != null) {
            throw new RuntimeException("This implementation only support a single web server.");
        }
        this.webServer = new WebServer(port);
        this.port = port;
        this.host = host;
    }

    public void removeListener(String host, int port) throws XmlRpcException {
        WebServer webServer = this.getWebServer(host, port);
        webServer.shutdown();
    }

    public void startListener(String host, int port) throws XmlRpcException {
        WebServer webServer = this.getWebServer(host, port);
        if (host == null) {
            this.getLogger().info("Starting XML-RPC listener on port '" + port + "'.");
        } else {
            this.getLogger().info("Starting XML-RPC listener on host '" + host + "', port '" + port + "'.");
        }
        webServer.start();
    }

    public void addHandler(String name, Object handler) throws XmlRpcException {
        this.webServer.addHandler(name, handler);
    }

    public void addHandler(String host, String name, int port, Object handler) throws XmlRpcException {
        WebServer webServer = this.getWebServer(host, port);
        webServer.addHandler(name, handler);
    }

    public void removeHandler(String name) throws XmlRpcException {
        this.webServer.removeHandler(name);
    }

    public void removeHandler(String host, int port, String name) throws XmlRpcException {
        WebServer webServer = this.getWebServer(host, port);
        webServer.removeHandler(name);
    }

    public void acceptClient(String clientHost) {
        this.webServer.setParanoid(true);
        this.webServer.acceptClient(clientHost);
    }

    public void acceptClient(String host, int port, String clientHost) {
        WebServer webServer = this.getWebServer(host, port);
        webServer.setParanoid(true);
        webServer.acceptClient(clientHost);
    }

    public void denyClient(String clientHost) {
        this.webServer.setParanoid(true);
        this.webServer.denyClient(clientHost);
    }

    public void denyClient(String host, int port, String clientHost) {
        WebServer webServer = this.getWebServer(host, port);
        webServer.setParanoid(true);
        webServer.denyClient(clientHost);
    }

    public void setParanoid(String host, int port, boolean state) {
        WebServer webServer = this.getWebServer(host, port);
        webServer.setParanoid(state);
    }

    private WebServer getWebServer(String host, int port) {
        if (port != this.port) {
            throw new RuntimeException("There isn't a listener on port " + port + ".");
        }
        if (!(host == null && this.host == null || host.equals(this.host))) {
            throw new RuntimeException("There isn't a listener on host '" + host + "'.");
        }
        return this.webServer;
    }
}

