/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire.api;

import java.io.File;
import org.apache.maven.project.MavenProject;
import org.sonar.api.batch.maven.MavenPlugin;
import org.sonar.api.resources.Project;

public final class SurefireUtils {
    public static File getReportsDirectory(Project project) {
        File dir = SurefireUtils.getReportsDirectoryFromProperty(project);
        if (dir == null) {
            dir = SurefireUtils.getReportsDirectoryFromPluginConfiguration(project);
        }
        if (dir == null) {
            dir = SurefireUtils.getReportsDirectoryFromDefaultConfiguration(project);
        }
        return dir;
    }

    private static File getReportsDirectoryFromProperty(Project project) {
        String path = (String)project.getProperty("sonar.surefire.reportsPath");
        if (path != null) {
            return project.getFileSystem().resolvePath(path);
        }
        return null;
    }

    private static File getReportsDirectoryFromPluginConfiguration(Project project) {
        String path;
        MavenPlugin plugin = MavenPlugin.getPlugin((MavenProject)project.getPom(), (String)"org.apache.maven.plugins", (String)"maven-surefire-plugin");
        if (plugin != null && (path = plugin.getParameter("reportsDirectory")) != null) {
            return project.getFileSystem().resolvePath(path);
        }
        return null;
    }

    private static File getReportsDirectoryFromDefaultConfiguration(Project project) {
        return new File(project.getFileSystem().getBuildDir(), "surefire-reports");
    }

    private SurefireUtils() {
    }
}

