/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.duplication;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.duplication.DuplicationDao;
import org.sonar.core.duplication.DuplicationUnitDto;
import org.sonar.core.persistence.AbstractDaoTestCase;

public class DuplicationDaoTest
extends AbstractDaoTestCase {
    private DuplicationDao dao;

    @Before
    public void createDao() throws Exception {
        this.dao = new DuplicationDao(this.getMyBatis());
    }

    @Test
    public void shouldGetByHash() throws Exception {
        this.setupData("shouldGetByHash");
        List blocks = this.dao.selectCandidates(10, Integer.valueOf(7), "java");
        Assert.assertThat((Object)blocks.size(), (Matcher)Matchers.is((Object)1));
        DuplicationUnitDto block = (DuplicationUnitDto)blocks.get(0);
        Assert.assertThat((String)"block resourceId", (Object)block.getResourceKey(), (Matcher)Matchers.is((Object)"bar-last"));
        Assert.assertThat((String)"block hash", (Object)block.getHash(), (Matcher)Matchers.is((Object)"aa"));
        Assert.assertThat((String)"block index in file", (Object)block.getIndexInFile(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((String)"block start line", (Object)block.getStartLine(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((String)"block end line", (Object)block.getEndLine(), (Matcher)Matchers.is((Object)2));
        blocks = this.dao.selectCandidates(10, null, "java");
        Assert.assertThat((Object)blocks.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void shouldInsert() throws Exception {
        this.setupData("shouldInsert");
        this.dao.insert(Arrays.asList(new DuplicationUnitDto(Integer.valueOf(1), Integer.valueOf(2), "bb", Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2))));
        this.checkTables("shouldInsert", "duplications_index");
    }
}

