/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.filters;

import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.filter.CriterionDto;
import org.sonar.core.filter.FilterColumnDto;
import org.sonar.core.filter.FilterDao;
import org.sonar.core.filter.FilterDto;
import org.sonar.core.persistence.AbstractDaoTestCase;

public class FilterDaoTest
extends AbstractDaoTestCase {
    private FilterDao dao;

    @Before
    public void createDao() {
        this.dao = new FilterDao(this.getMyBatis());
    }

    @Test
    public void should_find_filter() {
        this.setupData("shouldFindFilter");
        FilterDto filter = this.dao.findFilter("Projects");
        Assertions.assertThat((Long)filter.getId()).isEqualTo(1L);
        Assertions.assertThat((String)filter.getName()).isEqualTo((Object)"Projects");
        Assertions.assertThat((String)filter.getKey()).isEqualTo((Object)"Projects");
        Assertions.assertThat((Object)this.dao.findFilter("<UNKNOWN>")).isNull();
    }

    @Test
    public void should_insert() {
        this.setupData("shouldInsert");
        FilterDto filterDto = new FilterDto();
        filterDto.setName("Projects");
        filterDto.setKey("Projects");
        filterDto.setShared(Boolean.valueOf(true));
        filterDto.setFavourites(Boolean.valueOf(false));
        filterDto.setDefaultView("list");
        filterDto.setPageSize(Long.valueOf(10L));
        CriterionDto criterionDto = new CriterionDto();
        criterionDto.setFamily("family");
        criterionDto.setKey("key");
        criterionDto.setOperator("=");
        criterionDto.setValue(Float.valueOf(1.5f));
        criterionDto.setTextValue("1.5");
        criterionDto.setVariation(Boolean.valueOf(true));
        filterDto.add(criterionDto);
        FilterColumnDto filterColumnDto = new FilterColumnDto();
        filterColumnDto.setFamily("family");
        filterColumnDto.setKey("key");
        filterColumnDto.setSortDirection("ASC");
        filterColumnDto.setOrderIndex(Long.valueOf(2L));
        filterColumnDto.setVariation(Boolean.valueOf(true));
        filterDto.add(filterColumnDto);
        this.dao.insert(filterDto);
        this.checkTables("shouldInsert", "filters", "criteria", "filter_columns");
    }
}

