/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.i18n;

import com.google.common.collect.Lists;
import java.util.Locale;
import java.util.ResourceBundle;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.StringContains;
import org.junit.matchers.JUnitMatchers;
import org.mockito.Mockito;
import org.sonar.core.i18n.GwtI18n;
import org.sonar.core.i18n.I18nManager;

public class GwtI18nTest {
    private GwtI18n i18n;
    private ResourceBundle bundle;

    @Before
    public void init() {
        this.bundle = ResourceBundle.getBundle("org.sonar.core.i18n.GwtI18nTest.gwt", Locale.ENGLISH);
        this.i18n = new GwtI18n((I18nManager)Mockito.mock(I18nManager.class));
        this.i18n.doStart(this.bundle);
    }

    @Test
    public void shouldListAllPropertyKeysAtStartup() {
        Assert.assertThat((Object)this.i18n.getPropertyKeys().length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)Lists.newArrayList((Object[])this.i18n.getPropertyKeys()), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{"one", "two"}));
    }

    @Test
    public void shouldEncodeJavascriptValues() {
        String js = this.i18n.getJsDictionnary(this.bundle);
        Assert.assertThat((Object)js, (Matcher)StringContains.containsString((String)"var l10n = {"));
        Assert.assertThat((Object)js, (Matcher)StringContains.containsString((String)"one\": \"One"));
        Assert.assertThat((Object)js, (Matcher)StringContains.containsString((String)"two\": \"Two"));
        Assert.assertThat((Object)js, (Matcher)StringContains.containsString((String)"};"));
        Assert.assertThat((Object)js, (Matcher)CoreMatchers.not((Matcher)StringContains.containsString((String)",};")));
    }
}

