/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.i18n;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.mockito.Mockito;
import org.sonar.core.i18n.I18nManager;
import org.sonar.core.i18n.RuleI18nManager;

public class RuleI18nManagerTest {
    @Test
    public void shouldGetName() {
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        ruleI18n.getName("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck", Locale.ENGLISH);
        String propertyKey = "rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name";
        ((I18nManager)Mockito.verify((Object)i18n)).message(Locale.ENGLISH, propertyKey, null, new Object[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{i18n});
    }

    @Test
    public void shouldGetParamDescription() {
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        ruleI18n.getParamDescription("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck", "pattern", Locale.ENGLISH);
        String propertyKey = "rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.param.pattern";
        ((I18nManager)Mockito.verify((Object)i18n)).message(Locale.ENGLISH, propertyKey, null, new Object[0]);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{i18n});
    }

    @Test
    public void shouldGetDescriptionFromFile() {
        String propertyKeyForName = "rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name";
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        Mockito.when((Object)i18n.messageFromFile(Locale.ENGLISH, "rules/checkstyle/com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true)).thenReturn((Object)"Description");
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        String description = ruleI18n.getDescription("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck", Locale.ENGLISH);
        Assert.assertThat((Object)description, (Matcher)Matchers.is((Object)"Description"));
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.ENGLISH, "rules/checkstyle/com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{i18n});
    }

    @Test
    public void shouldGetDescriptionFromFileWithBackwardCompatibility() {
        String propertyKeyForName = "rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name";
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        Mockito.when((Object)i18n.messageFromFile(Locale.ENGLISH, "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true)).thenReturn((Object)"Description");
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        String description = ruleI18n.getDescription("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck", Locale.ENGLISH);
        Assert.assertThat((Object)description, (Matcher)Matchers.is((Object)"Description"));
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.ENGLISH, "rules/checkstyle/com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.ENGLISH, "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{i18n});
    }

    @Test
    public void shouldGetDescriptionFromFileWithBackwardCompatibilityWithSpecificLocale() {
        String propertyKeyForName = "rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name";
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        Mockito.when((Object)i18n.messageFromFile(Locale.ENGLISH, "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true)).thenReturn((Object)"Description");
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        String description = ruleI18n.getDescription("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck", Locale.FRENCH);
        Assert.assertThat((Object)description, (Matcher)Matchers.is((Object)"Description"));
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.FRENCH, "rules/checkstyle/com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.FRENCH, "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.ENGLISH, "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{i18n});
    }

    @Test
    public void shouldUseOnlyLanguage() {
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        ruleI18n.getDescription("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck", new Locale("fr", "BE"));
        String propertyKeyForName = "rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name";
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(new Locale("fr"), "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
    }

    @Test
    public void shoudlReturnNullIfMissingDescription() {
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        Assert.assertThat((Object)ruleI18n.getDescription("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck", Locale.ENGLISH), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldUseEnglishIfMissingLocale() {
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        ruleI18n.getDescription("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck", Locale.FRENCH);
        String propertyKeyForName = "rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name";
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.FRENCH, "rules/checkstyle/com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.FRENCH, "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.ENGLISH, "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        ((I18nManager)Mockito.verify((Object)i18n)).messageFromFile(Locale.ENGLISH, "rules/checkstyle/com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.html", propertyKeyForName, true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{i18n});
    }

    @Test
    public void shouldBeRuleKey() {
        Assert.assertThat((Object)RuleI18nManager.isRuleProperty((String)"rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)RuleI18nManager.isRuleProperty((String)"rule.pmd.Header.name"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldNotBeRuleKey() {
        Assert.assertThat((Object)RuleI18nManager.isRuleProperty((String)"rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.param.name"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)RuleI18nManager.isRuleProperty((String)"by"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)RuleI18nManager.isRuleProperty((String)"something.else"), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)RuleI18nManager.isRuleProperty((String)"checkstyle.page.name"), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldExtractRuleKey() {
        RuleI18nManager.RuleKey ruleKey = RuleI18nManager.extractRuleKey((String)"rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name");
        Assert.assertThat((Object)ruleKey.getRepositoryKey(), (Matcher)Is.is((Object)"checkstyle"));
        Assert.assertThat((Object)ruleKey.getKey(), (Matcher)Is.is((Object)"com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck"));
        Assert.assertThat((Object)ruleKey.getNameProperty(), (Matcher)Is.is((Object)"rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name"));
        ruleKey = RuleI18nManager.extractRuleKey((String)"rule.pmd.Header.name");
        Assert.assertThat((Object)ruleKey.getRepositoryKey(), (Matcher)Is.is((Object)"pmd"));
        Assert.assertThat((Object)ruleKey.getKey(), (Matcher)Is.is((Object)"Header"));
        Assert.assertThat((Object)ruleKey.getNameProperty(), (Matcher)Is.is((Object)"rule.pmd.Header.name"));
    }

    @Test
    public void shouldRegisterRuleKeysAtStartup() {
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        Mockito.when((Object)i18n.getPropertyKeys()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{"rule.pmd.Header.name", "rule.pmd.Header.param.pattern", "rule.checkstyle.com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck.name", "by", "something.else"}));
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        ruleI18n.start();
        List<RuleI18nManager.RuleKey> keys = Arrays.asList(ruleI18n.getRuleKeys());
        Assert.assertThat((Object)keys.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(keys, (Matcher)JUnitMatchers.hasItem((Object)new RuleI18nManager.RuleKey("pmd", "Header")));
        Assert.assertThat(keys, (Matcher)JUnitMatchers.hasItem((Object)new RuleI18nManager.RuleKey("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck")));
    }

    @Test
    public void shouldSearchEnglishNames() {
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        Mockito.when((Object)i18n.getPropertyKeys()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{"rule.pmd.Header.name", "rule.checkstyle.AnnotationUseStyleCheck.name"}));
        Mockito.when((Object)i18n.message(Locale.ENGLISH, "rule.pmd.Header.name", null, new Object[0])).thenReturn((Object)"HEADER PMD CHECK");
        Mockito.when((Object)i18n.message(Locale.ENGLISH, "rule.checkstyle.AnnotationUseStyleCheck.name", null, new Object[0])).thenReturn((Object)"check annotation style");
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        ruleI18n.start();
        List result = ruleI18n.searchNames("ANNOTATion", Locale.ENGLISH);
        Assert.assertThat((Object)result.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((RuleI18nManager.RuleKey)result.get(0)).getRepositoryKey(), (Matcher)Is.is((Object)"checkstyle"));
        result = ruleI18n.searchNames("bibopaloula", Locale.ENGLISH);
        Assert.assertThat((Object)result.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldSearchLocalizedNames() {
        I18nManager i18n = (I18nManager)Mockito.mock(I18nManager.class);
        Mockito.when((Object)i18n.getPropertyKeys()).thenReturn((Object)Sets.newHashSet((Object[])new String[]{"rule.pmd.Header.name", "rule.checkstyle.AnnotationUseStyleCheck.name"}));
        Mockito.when((Object)i18n.message(Locale.ENGLISH, "rule.pmd.Header.name", null, new Object[0])).thenReturn((Object)"HEADER PMD CHECK");
        Mockito.when((Object)i18n.message(Locale.ENGLISH, "rule.checkstyle.AnnotationUseStyleCheck.name", null, new Object[0])).thenReturn((Object)"check annotation style");
        Mockito.when((Object)i18n.message(Locale.FRENCH, "rule.checkstyle.AnnotationUseStyleCheck.name", null, new Object[0])).thenReturn((Object)"v\u00e9rifie le style des annotations");
        RuleI18nManager ruleI18n = new RuleI18nManager(i18n);
        ruleI18n.start();
        List result = ruleI18n.searchNames("annotation", Locale.FRENCH);
        Assert.assertThat((Object)result.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((RuleI18nManager.RuleKey)result.get(0)).getKey(), (Matcher)Is.is((Object)"AnnotationUseStyleCheck"));
        result = ruleI18n.searchNames("v\u00e9rifie", Locale.FRENCH);
        Assert.assertThat((Object)result.size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)((RuleI18nManager.RuleKey)result.get(0)).getKey(), (Matcher)Is.is((Object)"AnnotationUseStyleCheck"));
    }
}

