/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.measure;

import java.util.Date;
import java.util.List;
import org.fest.assertions.Assertions;
import org.json.simple.parser.ParseException;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.MetricFinder;
import org.sonar.core.measure.MeasureFilter;
import org.sonar.core.measure.MeasureFilterCondition;
import org.sonar.core.measure.MeasureFilterDecoder;
import org.sonar.core.measure.MeasureFilterSort;

public class MeasureFilterDecoderTest {
    private MetricFinder metricFinder;

    @Before
    public void before() {
        this.metricFinder = (MetricFinder)Mockito.mock(MetricFinder.class);
        Mockito.when((Object)this.metricFinder.findByKey(Matchers.anyString())).thenAnswer((Answer)new Answer<Metric>(){

            public Metric answer(InvocationOnMock invocationOnMock) throws Throwable {
                return new Metric((String)invocationOnMock.getArguments()[0]);
            }
        });
    }

    @Test
    public void should_decode() throws ParseException {
        String json = "{\"base\": \"org.struts\", \"onBaseChildren\": true, \"scopes\": [\"PRJ\"], \"qualifiers\": [\"TRK\",\"CLA\"], \"keyRegexp\": \"*foo*\"\"languages\": [\"java\", \"php\"], \"name\": \"Struts\", \"fromDate\": \"2012-12-25\", \"toDate\": \"2013-01-31\", \"favourites\": true, \"sortAsc\": true, \"sortField\": \"METRIC\", \"sortMetric\": \"ncloc\", \"sortPeriod\":5, \"conditions\":[{\"metric\":\"lines\", \"op\":\">\", \"val\":123.0}]}";
        MeasureFilter filter = new MeasureFilterDecoder(this.metricFinder).decode(json);
        Assertions.assertThat((String)filter.getBaseResourceKey()).isEqualTo((Object)"org.struts");
        Assertions.assertThat((boolean)filter.isOnBaseResourceChildren()).isTrue();
        Assertions.assertThat((List)filter.getResourceScopes()).containsExactly(new Object[]{"PRJ"});
        Assertions.assertThat((List)filter.getResourceQualifiers()).containsExactly(new Object[]{"TRK", "CLA"});
        Assertions.assertThat((List)filter.getResourceLanguages()).containsExactly(new Object[]{"java", "php"});
        Assertions.assertThat((String)filter.getResourceName()).isEqualTo((Object)"Struts");
        Assertions.assertThat((String)filter.getResourceKeyRegexp()).isEqualTo((Object)"*foo*");
        Assertions.assertThat((int)filter.getFromDate().getYear()).isEqualTo(112);
        Assertions.assertThat((int)filter.getToDate().getYear()).isEqualTo(113);
        Assertions.assertThat((boolean)filter.isOnFavourites()).isTrue();
        Assertions.assertThat((String)filter.sort().metric().getKey()).isEqualTo((Object)"ncloc");
        Assertions.assertThat((boolean)filter.sort().isAsc()).isTrue();
        MeasureFilterCondition condition = (MeasureFilterCondition)filter.getMeasureConditions().get(0);
        Assertions.assertThat((String)condition.metric().getKey()).isEqualTo((Object)"lines");
        Assertions.assertThat((String)condition.operator()).isEqualTo((Object)">");
        Assertions.assertThat((double)condition.value()).isEqualTo(123.0);
    }

    @Test
    public void should_set_max_date_by_number_of_days() throws ParseException {
        String json = "{\"beforeDays\": 5}";
        MeasureFilter filter = new MeasureFilterDecoder(this.metricFinder).decode(json);
        Assertions.assertThat((Object)filter.getFromDate()).isNull();
        Assertions.assertThat((boolean)filter.getToDate().before(new Date())).isTrue();
    }

    @Test
    public void should_set_min_date_by_number_of_days() throws ParseException {
        String json = "{\"afterDays\": 5}";
        MeasureFilter filter = new MeasureFilterDecoder(this.metricFinder).decode(json);
        Assertions.assertThat((Object)filter.getToDate()).isNull();
        Assertions.assertThat((boolean)filter.getFromDate().before(new Date())).isTrue();
    }

    @Test
    public void test_default_values() throws ParseException {
        MeasureFilter filter = new MeasureFilterDecoder(this.metricFinder).decode("{}");
        Assertions.assertThat((String)filter.getBaseResourceKey()).isNull();
        Assertions.assertThat((boolean)filter.isOnBaseResourceChildren()).isFalse();
        Assertions.assertThat((List)filter.getResourceScopes()).isEmpty();
        Assertions.assertThat((List)filter.getResourceQualifiers()).isEmpty();
        Assertions.assertThat((List)filter.getResourceLanguages()).isEmpty();
        Assertions.assertThat((String)filter.getResourceName()).isNull();
        Assertions.assertThat((String)filter.getResourceKeyRegexp()).isNull();
        Assertions.assertThat((Object)filter.getFromDate()).isNull();
        Assertions.assertThat((Object)filter.getToDate()).isNull();
        Assertions.assertThat((boolean)filter.isOnFavourites()).isFalse();
        Assertions.assertThat((Object)filter.sort().metric()).isNull();
        Assertions.assertThat((Integer)filter.sort().getPeriod()).isNull();
        Assertions.assertThat((boolean)filter.sort().onMeasures()).isFalse();
        Assertions.assertThat((Object)filter.sort().field()).isEqualTo((Object)MeasureFilterSort.Field.NAME);
        Assertions.assertThat((boolean)filter.sort().isAsc()).isTrue();
        Assertions.assertThat((List)filter.getMeasureConditions()).isEmpty();
    }
}

