/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.measure;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.json.simple.parser.ParseException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.sonar.core.measure.MeasureFilter;
import org.sonar.core.measure.MeasureFilterContext;
import org.sonar.core.measure.MeasureFilterDecoder;
import org.sonar.core.measure.MeasureFilterEngine;
import org.sonar.core.measure.MeasureFilterExecutor;

public class MeasureFilterEngineTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void should_decode_json_and_execute_filter() throws Exception {
        MeasureFilterDecoder decoder = (MeasureFilterDecoder)Mockito.mock(MeasureFilterDecoder.class);
        MeasureFilter filter = new MeasureFilter();
        Mockito.when((Object)decoder.decode("{}")).thenReturn((Object)filter);
        MeasureFilterExecutor executor = (MeasureFilterExecutor)Mockito.mock(MeasureFilterExecutor.class);
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.when((Object)logger.isDebugEnabled()).thenReturn((Object)true);
        MeasureFilterEngine engine = new MeasureFilterEngine(decoder, executor);
        long userId = 50L;
        engine.execute("{}", Long.valueOf(50L), logger);
        ((MeasureFilterExecutor)Mockito.verify((Object)executor)).execute((MeasureFilter)Mockito.refEq((Object)filter, (String[])new String[0]), (MeasureFilterContext)Matchers.argThat((Matcher)new BaseMatcher<MeasureFilterContext>(){

            public boolean matches(Object o) {
                MeasureFilterContext context = (MeasureFilterContext)o;
                return "{}".equals(context.getJson()) && context.getUserId() == 50L;
            }

            public void describeTo(Description description) {
            }
        }));
        ((Logger)Mockito.verify((Object)logger)).debug(Mockito.anyString());
    }

    @Test
    public void throw_definition_of_filter_on_error() throws Exception {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("filter=<xml>");
        MeasureFilterDecoder decoder = (MeasureFilterDecoder)Mockito.mock(MeasureFilterDecoder.class);
        Mockito.when((Object)decoder.decode("<xml>")).thenThrow(new Throwable[]{new ParseException(0)});
        MeasureFilterExecutor executor = (MeasureFilterExecutor)Mockito.mock(MeasureFilterExecutor.class);
        MeasureFilterEngine engine = new MeasureFilterEngine(decoder, executor);
        engine.execute("<xml>", Long.valueOf(50L));
    }
}

