/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.measure;

import java.sql.SQLException;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.sonar.api.measures.Metric;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.measure.MeasureFilter;
import org.sonar.core.measure.MeasureFilterCondition;
import org.sonar.core.measure.MeasureFilterContext;
import org.sonar.core.measure.MeasureFilterExecutor;
import org.sonar.core.measure.MeasureFilterRow;
import org.sonar.core.measure.MeasureFilterSort;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.resource.ResourceDao;
import org.sonar.core.resource.SnapshotDto;

public class MeasureFilterExecutorTest
extends AbstractDaoTestCase {
    private static final long JAVA_PROJECT_ID = 1L;
    private static final long JAVA_FILE_BIG_ID = 3L;
    private static final long JAVA_FILE_TINY_ID = 4L;
    private static final long JAVA_PROJECT_SNAPSHOT_ID = 101L;
    private static final long JAVA_FILE_BIG_SNAPSHOT_ID = 103L;
    private static final long JAVA_FILE_TINY_SNAPSHOT_ID = 104L;
    private static final long JAVA_PACKAGE_SNAPSHOT_ID = 102L;
    private static final long PHP_PROJECT_ID = 10L;
    private static final long PHP_SNAPSHOT_ID = 110L;
    private static final Metric METRIC_LINES = new Metric.Builder("lines", "Lines", Metric.ValueType.INT).create().setId(Integer.valueOf(1));
    private static final Metric METRIC_PROFILE = new Metric.Builder("profile", "Profile", Metric.ValueType.STRING).create().setId(Integer.valueOf(2));
    private static final Metric METRIC_COVERAGE = new Metric.Builder("coverage", "Coverage", Metric.ValueType.FLOAT).create().setId(Integer.valueOf(3));
    private MeasureFilterExecutor executor;

    @Before
    public void before() {
        this.executor = new MeasureFilterExecutor(this.getMyBatis(), this.getDatabase(), new ResourceDao(this.getMyBatis()));
        this.setupData("shared");
    }

    @Test
    public void invalid_filter_should_not_return_results() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setUserFavourites(true);
        Assertions.assertThat((List)this.executor.execute(filter, new MeasureFilterContext())).isEmpty();
    }

    @Test
    public void filter_is_not_valid_if_missing_base_snapshot() {
        MeasureFilterContext context = new MeasureFilterContext();
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setOnBaseResourceChildren(true);
        Assertions.assertThat((boolean)MeasureFilterExecutor.isValid((MeasureFilter)filter, (MeasureFilterContext)context)).isFalse();
        context.setBaseSnapshot(new SnapshotDto().setId(Long.valueOf(123L)));
        Assertions.assertThat((boolean)MeasureFilterExecutor.isValid((MeasureFilter)filter, (MeasureFilterContext)context)).isTrue();
    }

    @Test
    public void filter_is_not_valid_if_condition_on_unknown_metric() {
        MeasureFilterContext context = new MeasureFilterContext();
        MeasureFilter filter = new MeasureFilter().addCondition(new MeasureFilterCondition(null, "<", 3.0));
        Assertions.assertThat((boolean)MeasureFilterExecutor.isValid((MeasureFilter)filter, (MeasureFilterContext)context)).isFalse();
    }

    @Test
    public void filter_is_not_valid_if_sorting_on_unknown_metric() {
        MeasureFilterContext context = new MeasureFilterContext();
        MeasureFilter filter = new MeasureFilter().setSortOnMetric(null);
        Assertions.assertThat((boolean)MeasureFilterExecutor.isValid((MeasureFilter)filter, (MeasureFilterContext)context)).isFalse();
    }

    @Test
    public void filter_is_not_valid_if_anonymous_favourites() {
        MeasureFilterContext context = new MeasureFilterContext();
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setUserFavourites(true);
        Assertions.assertThat((boolean)MeasureFilterExecutor.isValid((MeasureFilter)filter, (MeasureFilterContext)context)).isFalse();
        context.setUserId(Long.valueOf(123L));
        Assertions.assertThat((boolean)MeasureFilterExecutor.isValid((MeasureFilter)filter, (MeasureFilterContext)context)).isTrue();
    }

    @Test
    public void projects_without_measure_conditions() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setSortOn(MeasureFilterSort.Field.LANGUAGE);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaProject((MeasureFilterRow)rows.get(0));
        this.verifyPhpProject((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void test_default_sort() {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"});
        Assertions.assertThat((boolean)filter.sort().isAsc()).isTrue();
        Assertions.assertThat((Object)filter.sort().field()).isEqualTo((Object)MeasureFilterSort.Field.NAME);
        Assertions.assertThat((Object)filter.sort().metric()).isNull();
    }

    @Test
    public void sort_by_ascending_resource_name() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setSortAsc(true);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaBigFile((MeasureFilterRow)rows.get(0));
        this.verifyJavaTinyFile((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_ascending_resource_key() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setSortAsc(true).setSortOn(MeasureFilterSort.Field.KEY);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaBigFile((MeasureFilterRow)rows.get(0));
        this.verifyJavaTinyFile((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_ascending_resource_version() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setSortAsc(true).setSortOn(MeasureFilterSort.Field.VERSION);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaProject((MeasureFilterRow)rows.get(0));
        this.verifyPhpProject((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_descending_resource_name() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setSortAsc(false);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaTinyFile((MeasureFilterRow)rows.get(0));
        this.verifyJavaBigFile((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_ascending_text_measure() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setSortOnMetric(METRIC_PROFILE);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyPhpProject((MeasureFilterRow)rows.get(0));
        this.verifyJavaProject((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_descending_text_measure() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setSortOnMetric(METRIC_PROFILE).setSortAsc(false);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaProject((MeasureFilterRow)rows.get(0));
        this.verifyPhpProject((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_missing_text_measure() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setSortOnMetric(METRIC_PROFILE);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
    }

    @Test
    public void sort_by_ascending_numeric_measure() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setSortOnMetric(METRIC_LINES);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaTinyFile((MeasureFilterRow)rows.get(0));
        this.verifyJavaBigFile((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_descending_numeric_measure() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setSortOnMetric(METRIC_LINES).setSortAsc(false);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaBigFile((MeasureFilterRow)rows.get(0));
        this.verifyJavaTinyFile((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_missing_numeric_measure() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setSortOnMetric(METRIC_COVERAGE);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
    }

    @Test
    public void sort_by_ascending_variation() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setSortOnMetric(METRIC_LINES).setSortOnPeriod(5);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaProject((MeasureFilterRow)rows.get(0));
        this.verifyPhpProject((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_descending_variation() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setSortOnMetric(METRIC_LINES).setSortOnPeriod(5).setSortAsc(false);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyPhpProject((MeasureFilterRow)rows.get(0));
        this.verifyJavaProject((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_ascending_date() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setSortOn(MeasureFilterSort.Field.DATE);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        this.verifyJavaProject((MeasureFilterRow)rows.get(0));
        this.verifyPhpProject((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void sort_by_descending_date() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setSortOn(MeasureFilterSort.Field.DATE).setSortAsc(false);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        this.verifyPhpProject((MeasureFilterRow)rows.get(0));
        this.verifyJavaProject((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void condition_on_numeric_measure() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setSortOnMetric(METRIC_LINES).addCondition(new MeasureFilterCondition(METRIC_LINES, ">", 200.0));
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        this.verifyJavaBigFile((MeasureFilterRow)rows.get(0));
    }

    @Test
    public void condition_on_measure_variation() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setSortOnMetric(METRIC_LINES).addCondition(new MeasureFilterCondition(METRIC_LINES, ">", 1000.0).setPeriod(Integer.valueOf(5)));
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        this.verifyPhpProject((MeasureFilterRow)rows.get(0));
    }

    @Test
    public void multiple_conditions_on_numeric_measures() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setSortOnMetric(METRIC_LINES).addCondition(new MeasureFilterCondition(METRIC_LINES, ">", 2.0)).addCondition(new MeasureFilterCondition(METRIC_LINES, "<=", 50.0));
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        this.verifyJavaTinyFile((MeasureFilterRow)rows.get(0));
    }

    @Test
    public void filter_by_language() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setResourceLanguages(new String[]{"java", "cobol"});
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        this.verifyJavaProject((MeasureFilterRow)rows.get(0));
    }

    @Test
    public void filter_by_min_date() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setFromDate(DateUtils.parseDate((String)"2012-12-13"));
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        this.verifyPhpProject((MeasureFilterRow)rows.get(0));
    }

    @Test
    public void filter_by_range_of_dates() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setFromDate(DateUtils.parseDate((String)"2007-01-01")).setToDate(DateUtils.parseDate((String)"2010-01-01"));
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        this.verifyJavaProject((MeasureFilterRow)rows.get(0));
    }

    @Test
    public void filter_by_resource_name() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setResourceName("PHP Proj");
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        this.verifyPhpProject((MeasureFilterRow)rows.get(0));
    }

    @Test
    public void filter_by_resource_key_star_regexp() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setResourceKeyRegexp("java*");
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        this.verifyJavaProject((MeasureFilterRow)rows.get(0));
    }

    @Test
    public void filter_by_resource_key_exclamation_mark() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK"}).setResourceKeyRegexp("JaV?_proje*");
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        this.verifyJavaProject((MeasureFilterRow)rows.get(0));
    }

    @Test
    public void filter_by_base_resource() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"CLA"}).setBaseResourceKey("java_project");
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaBigFile((MeasureFilterRow)rows.get(0));
        this.verifyJavaTinyFile((MeasureFilterRow)rows.get(1));
    }

    @Test
    public void filter_by_parent_resource() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setBaseResourceKey("java_project").setOnBaseResourceChildren(true);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).hasSize(1);
        Assertions.assertThat((long)((MeasureFilterRow)rows.get(0)).getSnapshotId()).isEqualTo(102L);
    }

    @Test
    public void filter_by_parent_without_children() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setResourceQualifiers(new String[]{"TRK", "PAC", "CLA"}).setBaseResourceKey("java_project:org.sonar.foo.Big").setOnBaseResourceChildren(true);
        List rows = this.executor.execute(filter, new MeasureFilterContext());
        Assertions.assertThat((List)rows).isEmpty();
    }

    @Test
    public void filter_by_user_favourites() throws SQLException {
        MeasureFilter filter = new MeasureFilter().setUserFavourites(true);
        List rows = this.executor.execute(filter, new MeasureFilterContext().setUserId(Long.valueOf(50L)));
        Assertions.assertThat((List)rows).hasSize(2);
        this.verifyJavaBigFile((MeasureFilterRow)rows.get(0));
        this.verifyPhpProject((MeasureFilterRow)rows.get(1));
    }

    private void verifyJavaProject(MeasureFilterRow row) {
        Assertions.assertThat((long)row.getSnapshotId()).isEqualTo(101L);
        Assertions.assertThat((long)row.getResourceId()).isEqualTo(1L);
        Assertions.assertThat((long)row.getResourceRootId()).isEqualTo(1L);
    }

    private void verifyJavaBigFile(MeasureFilterRow row) {
        Assertions.assertThat((long)row.getSnapshotId()).isEqualTo(103L);
        Assertions.assertThat((long)row.getResourceId()).isEqualTo(3L);
        Assertions.assertThat((long)row.getResourceRootId()).isEqualTo(1L);
    }

    private void verifyJavaTinyFile(MeasureFilterRow row) {
        Assertions.assertThat((long)row.getSnapshotId()).isEqualTo(104L);
        Assertions.assertThat((long)row.getResourceId()).isEqualTo(4L);
        Assertions.assertThat((long)row.getResourceRootId()).isEqualTo(1L);
    }

    private void verifyPhpProject(MeasureFilterRow row) {
        Assertions.assertThat((long)row.getSnapshotId()).isEqualTo(110L);
        Assertions.assertThat((long)row.getResourceId()).isEqualTo(10L);
        Assertions.assertThat((long)row.getResourceRootId()).isEqualTo(10L);
    }
}

