/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.sonar.core.persistence.DatabaseUtils;
import org.sonar.core.persistence.dialect.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseCommands {
    private final IDataTypeFactory dbUnitFactory;
    private static final DatabaseCommands H2 = new DatabaseCommands((IDataTypeFactory)new H2DataTypeFactory()){

        @Override
        List<String> resetPrimaryKey(String table, int minSequenceValue) {
            return Arrays.asList("ALTER TABLE " + table + " ALTER COLUMN ID RESTART WITH " + minSequenceValue);
        }
    };
    private static final DatabaseCommands POSTGRESQL = new DatabaseCommands((IDataTypeFactory)new PostgresqlDataTypeFactory()){

        @Override
        List<String> resetPrimaryKey(String table, int minSequenceValue) {
            return Arrays.asList("ALTER SEQUENCE " + table + "_id_seq RESTART WITH " + minSequenceValue);
        }
    };
    private static final DatabaseCommands ORACLE = new DatabaseCommands((IDataTypeFactory)new Oracle10DataTypeFactory()){

        @Override
        List<String> resetPrimaryKey(String table, int minSequenceValue) {
            String sequence = StringUtils.upperCase((String)table) + "_SEQ";
            return Arrays.asList("DROP SEQUENCE " + sequence, "CREATE SEQUENCE " + sequence + " INCREMENT BY 1 MINVALUE 1 START WITH " + minSequenceValue);
        }
    };
    private static final DatabaseCommands MSSQL = new DatabaseCommands((IDataTypeFactory)new MsSqlDataTypeFactory()){

        @Override
        public void resetPrimaryKeys(DataSource dataSource) {
        }

        @Override
        List<String> resetPrimaryKey(String table, int minSequenceValue) {
            return null;
        }
    };
    private static final DatabaseCommands MYSQL = new DatabaseCommands((IDataTypeFactory)new MySqlDataTypeFactory()){

        @Override
        public void resetPrimaryKeys(DataSource dataSource) {
        }

        @Override
        List<String> resetPrimaryKey(String table, int minSequenceValue) {
            return null;
        }
    };

    private DatabaseCommands(IDataTypeFactory dbUnitFactory) {
        this.dbUnitFactory = dbUnitFactory;
    }

    public final IDataTypeFactory getDbUnitFactory() {
        return this.dbUnitFactory;
    }

    abstract List<String> resetPrimaryKey(String var1, int var2);

    public static DatabaseCommands forDialect(Dialect dialect) {
        DatabaseCommands command = (DatabaseCommands)ImmutableMap.of((Object)"h2", (Object)H2, (Object)"mssql", (Object)MSSQL, (Object)"mysql", (Object)MYSQL, (Object)"oracle", (Object)ORACLE, (Object)"postgresql", (Object)POSTGRESQL).get((Object)dialect.getId());
        return (DatabaseCommands)Preconditions.checkNotNull((Object)command, (Object)("Unknown database: " + dialect));
    }

    public void truncateDatabase(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        for (String table : DatabaseUtils.TABLE_NAMES) {
            statement.executeUpdate("TRUNCATE TABLE " + table);
            connection.commit();
        }
        statement.close();
        connection.close();
    }

    public void resetPrimaryKeys(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        for (String table : DatabaseUtils.TABLE_NAMES) {
            try {
                ResultSet result = statement.executeQuery("SELECT CASE WHEN MAX(ID) IS NULL THEN 1 ELSE MAX(ID)+1 END FROM " + table);
                result.next();
                int maxId = result.getInt(1);
                result.close();
                for (String resetCommand : this.resetPrimaryKey(table, maxId)) {
                    statement.executeUpdate(resetCommand);
                }
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
            }
        }
        statement.close();
        connection.close();
    }
}

