/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.persistence.DatabaseUtils;

public class DatabaseUtilsTest
extends AbstractDaoTestCase {
    @Test
    public void should_close_connection() throws SQLException {
        Connection connection = this.getConnection();
        Assertions.assertThat((boolean)this.isClosed(connection)).isFalse();
        DatabaseUtils.closeQuietly((Connection)connection);
        Assertions.assertThat((boolean)this.isClosed(connection)).isTrue();
    }

    @Test
    public void should_support_null_connection() {
        DatabaseUtils.closeQuietly((Connection)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_close_statement_and_resultset() throws SQLException {
        Connection connection = this.getConnection();
        try {
            PreparedStatement statement = connection.prepareStatement("SELECT 1");
            ResultSet rs = statement.executeQuery();
            DatabaseUtils.closeQuietly((ResultSet)rs);
            DatabaseUtils.closeQuietly((Statement)statement);
            Assertions.assertThat((boolean)this.isClosed(statement)).isTrue();
            Assertions.assertThat((boolean)this.isClosed(rs)).isTrue();
        }
        finally {
            DatabaseUtils.closeQuietly((Connection)connection);
        }
    }

    @Test
    public void should_not_fail_on_connection_errors() throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        ((Connection)Mockito.doThrow((Throwable)new SQLException()).when((Object)connection)).close();
        DatabaseUtils.closeQuietly((Connection)connection);
        ((Connection)Mockito.verify((Object)connection)).close();
    }

    @Test
    public void should_not_fail_on_statement_errors() throws SQLException {
        Statement statement = (Statement)Mockito.mock(Statement.class);
        ((Statement)Mockito.doThrow((Throwable)new SQLException()).when((Object)statement)).close();
        DatabaseUtils.closeQuietly((Statement)statement);
        ((Statement)Mockito.verify((Object)statement)).close();
    }

    @Test
    public void should_not_fail_on_resulset_errors() throws SQLException {
        ResultSet rs = (ResultSet)Mockito.mock(ResultSet.class);
        ((ResultSet)Mockito.doThrow((Throwable)new SQLException()).when((Object)rs)).close();
        DatabaseUtils.closeQuietly((ResultSet)rs);
        ((ResultSet)Mockito.verify((Object)rs)).close();
    }

    private boolean isClosed(Connection c) {
        try {
            c.createStatement().execute("SELECT 1");
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean isClosed(Statement s) {
        try {
            s.execute("SELECT 1");
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private boolean isClosed(ResultSet rs) {
        try {
            rs.next();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }
}

