/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.util.Properties;
import org.apache.commons.dbcp.BasicDataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.config.Settings;
import org.sonar.core.persistence.DefaultDatabase;

public class DefaultDatabaseTest {
    @Test
    public void shouldLoadDefaultValues() {
        DefaultDatabase db = new DefaultDatabase(new Settings());
        db.initSettings();
        Properties props = db.getProperties();
        Assert.assertThat((Object)props.getProperty("sonar.jdbc.username"), (Matcher)Is.is((Object)"sonar"));
        Assert.assertThat((Object)props.getProperty("sonar.jdbc.password"), (Matcher)Is.is((Object)"sonar"));
        Assert.assertThat((Object)props.getProperty("sonar.jdbc.url"), (Matcher)Is.is((Object)"jdbc:h2:tcp://localhost/sonar"));
        Assert.assertThat((Object)props.getProperty("sonar.jdbc.driverClassName"), (Matcher)Is.is((Object)"org.h2.Driver"));
    }

    @Test
    public void shouldSupportDeprecatedProperties() {
        Settings settings = new Settings();
        settings.setProperty("sonar.jdbc.driver", "my.Driver");
        settings.setProperty("sonar.jdbc.user", "me");
        DefaultDatabase db = new DefaultDatabase(settings);
        db.initSettings();
        Properties props = db.getProperties();
        Assert.assertThat((Object)props.getProperty("sonar.jdbc.username"), (Matcher)Is.is((Object)"me"));
        Assert.assertThat((Object)props.getProperty("sonar.jdbc.driverClassName"), (Matcher)Is.is((Object)"my.Driver"));
    }

    @Test
    public void shouldExtractCommonsDbcpProperties() {
        Properties props = new Properties();
        props.setProperty("sonar.jdbc.driverClassName", "my.Driver");
        props.setProperty("sonar.jdbc.username", "me");
        props.setProperty("sonar.jdbc.maxActive", "5");
        Properties commonsDbcpProps = DefaultDatabase.extractCommonsDbcpProperties((Properties)props);
        Assert.assertThat((Object)commonsDbcpProps.getProperty("username"), (Matcher)Is.is((Object)"me"));
        Assert.assertThat((Object)commonsDbcpProps.getProperty("driverClassName"), (Matcher)Is.is((Object)"my.Driver"));
        Assert.assertThat((Object)commonsDbcpProps.getProperty("maxActive"), (Matcher)Is.is((Object)"5"));
    }

    @Test
    public void shouldCompleteProperties() {
        Settings settings = new Settings();
        DefaultDatabase db = new DefaultDatabase(settings){

            protected void doCompleteProperties(Properties properties) {
                properties.setProperty("sonar.jdbc.maxActive", "2");
            }
        };
        db.initSettings();
        Properties props = db.getProperties();
        Assert.assertThat((Object)props.getProperty("sonar.jdbc.maxActive"), (Matcher)Is.is((Object)"2"));
    }

    @Test
    public void shouldStart() {
        Settings settings = new Settings();
        settings.setProperty("sonar.jdbc.url", "jdbc:h2:mem:sonar");
        settings.setProperty("sonar.jdbc.driverClassName", "org.h2.Driver");
        settings.setProperty("sonar.jdbc.username", "sonar");
        settings.setProperty("sonar.jdbc.password", "sonar");
        settings.setProperty("sonar.jdbc.maxActive", "1");
        DefaultDatabase db = new DefaultDatabase(settings);
        db.start();
        db.stop();
        Assert.assertThat((Object)db.getDialect().getId(), (Matcher)Is.is((Object)"h2"));
        Assert.assertThat((Object)((BasicDataSource)db.getDataSource()).getMaxActive(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldInitSchema() {
        Settings settings = new Settings();
        settings.setProperty("sonar.jdbc.schema", "my_schema");
        DefaultDatabase database = new DefaultDatabase(settings);
        database.initSettings();
        Assert.assertThat((Object)database.getSchema(), (Matcher)Is.is((Object)"my_schema"));
    }

    @Test
    public void shouldInitPostgresqlSchemaWithDeprecatedProperty() {
        Settings settings = new Settings();
        settings.setProperty("sonar.jdbc.dialect", "postgresql");
        settings.setProperty("sonar.jdbc.postgreSearchPath", "my_schema");
        DefaultDatabase database = new DefaultDatabase(settings);
        database.initSettings();
        Assert.assertThat((Object)database.getSchema(), (Matcher)Is.is((Object)"my_schema"));
    }

    @Test
    public void shouldNotInitPostgresqlSchemaByDefault() {
        Settings settings = new Settings();
        settings.setProperty("sonar.jdbc.dialect", "postgresql");
        DefaultDatabase database = new DefaultDatabase(settings);
        database.initSettings();
        Assert.assertThat((Object)database.getSchema(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldInitOracleSchemaWithDeprecatedProperty() {
        Settings settings = new Settings();
        settings.setProperty("sonar.jdbc.dialect", "oracle");
        settings.setProperty("sonar.hibernate.default_schema", "my_schema");
        DefaultDatabase database = new DefaultDatabase(settings);
        database.initSettings();
        Assert.assertThat((Object)database.getSchema(), (Matcher)Is.is((Object)"my_schema"));
    }

    @Test
    public void shouldNotInitOracleSchemaByDefault() {
        Settings settings = new Settings();
        settings.setProperty("sonar.jdbc.dialect", "oracle");
        DefaultDatabase database = new DefaultDatabase(settings);
        database.initSettings();
        Assert.assertThat((Object)database.getSchema(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void shouldGuessDialectFromUrl() {
        Settings settings = new Settings();
        settings.setProperty("sonar.jdbc.url", "jdbc:postgresql://localhost/sonar");
        DefaultDatabase database = new DefaultDatabase(settings);
        database.initSettings();
        Assert.assertThat((Object)database.getDialect().getId(), (Matcher)Is.is((Object)"postgresql"));
    }

    @Test
    public void shouldGuessDefaultDriver() {
        Settings settings = new Settings();
        settings.setProperty("sonar.jdbc.url", "jdbc:postgresql://localhost/sonar");
        DefaultDatabase database = new DefaultDatabase(settings);
        database.initSettings();
        Assert.assertThat((Object)database.getProperties().getProperty("sonar.jdbc.driverClassName"), (Matcher)Is.is((Object)"org.postgresql.Driver"));
    }
}

