/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.sonar.core.persistence.Database;
import org.sonar.core.persistence.DdlUtils;
import org.sonar.core.persistence.dialect.Dialect;
import org.sonar.core.persistence.dialect.H2;
import org.sonar.jpa.session.CustomHibernateConnectionProvider;

public class H2Database
implements Database {
    private final String name;
    private BasicDataSource datasource;

    public H2Database(String name) {
        this.name = name;
    }

    public H2Database start() {
        this.startDatabase();
        this.createSchema();
        return this;
    }

    private void startDatabase() {
        try {
            this.datasource = new BasicDataSource();
            this.datasource.setDriverClassName("org.h2.Driver");
            this.datasource.setUsername("sonar");
            this.datasource.setPassword("sonar");
            this.datasource.setUrl("jdbc:h2:mem:" + this.name);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to start H2", e);
        }
    }

    private void createSchema() {
        Connection connection = null;
        try {
            connection = this.datasource.getConnection();
            DdlUtils.createSchema((Connection)connection, (String)"h2");
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to create schema", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public H2Database stop() {
        try {
            this.datasource.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this;
    }

    public DataSource getDataSource() {
        return this.datasource;
    }

    public Dialect getDialect() {
        return new H2();
    }

    public String getSchema() {
        return null;
    }

    public Properties getHibernateProperties() {
        Properties properties = new Properties();
        properties.put("hibernate.hbm2ddl.auto", "validate");
        properties.put("hibernate.connection.provider_class", CustomHibernateConnectionProvider.class.getName());
        return properties;
    }
}

