/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence;

import ch.qos.logback.classic.Level;
import org.apache.ibatis.session.Configuration;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.config.Settings;
import org.sonar.core.config.Logback;
import org.sonar.core.persistence.BatchSession;
import org.sonar.core.persistence.Database;
import org.sonar.core.persistence.H2Database;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.rule.RuleMapper;

public class MyBatisTest {
    private static H2Database database;
    private Logback logback = (Logback)Mockito.mock(Logback.class);

    @BeforeClass
    public static void start() {
        database = new H2Database("sonar2");
        database.start();
    }

    @AfterClass
    public static void stop() {
        database.stop();
    }

    @Test
    public void shouldConfigureMyBatis() {
        MyBatis myBatis = new MyBatis((Database)database, new Settings(), this.logback);
        myBatis.start();
        Configuration conf = myBatis.getSessionFactory().getConfiguration();
        Assert.assertThat((Object)conf.isUseGeneratedKeys(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)conf.hasMapper(RuleMapper.class), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)conf.isLazyLoadingEnabled(), (Matcher)Is.is((Object)false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOpenBatchSession() {
        MyBatis myBatis = new MyBatis((Database)database, new Settings(), this.logback);
        myBatis.start();
        BatchSession session = myBatis.openBatchSession();
        try {
            Assert.assertThat((Object)session.getConnection(), (Matcher)Matchers.notNullValue());
            Assert.assertThat((Object)session.getMapper(RuleMapper.class), (Matcher)Matchers.notNullValue());
        }
        finally {
            session.close();
        }
    }

    @Test
    public void log_sql_requests() {
        Settings settings = new Settings().setProperty("sonar.showSql", Boolean.valueOf(true));
        MyBatis myBatis = new MyBatis((Database)database, settings, this.logback);
        myBatis.start();
        ((Logback)Mockito.verify((Object)this.logback)).setLoggerLevel("org.sonar.core.resource.ResourceIndexerMapper", Level.DEBUG);
    }

    @Test
    public void log_sql_requests_and_responses() {
        Settings settings = new Settings().setProperty("sonar.showSql", Boolean.valueOf(true)).setProperty("sonar.showSqlResults", Boolean.valueOf(true));
        MyBatis myBatis = new MyBatis((Database)database, settings, this.logback);
        myBatis.start();
        ((Logback)Mockito.verify((Object)this.logback)).setLoggerLevel("org.sonar.core.resource.ResourceIndexerMapper", Level.TRACE);
    }
}

