/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import org.fest.assertions.Assertions;
import org.junit.Test;
import org.sonar.core.persistence.dialect.MsSql;

public class MsSqlTest {
    private MsSql msSql = new MsSql();

    @Test
    public void matchesJdbcURL() {
        Assertions.assertThat((boolean)this.msSql.matchesJdbcURL("jdbc:jtds:sqlserver://localhost;databaseName=SONAR;SelectMethod=Cursor")).isTrue();
        Assertions.assertThat((boolean)this.msSql.matchesJdbcURL("jdbc:microsoft:sqlserver://localhost:1433;databasename=sonar")).isTrue();
        Assertions.assertThat((boolean)this.msSql.matchesJdbcURL("jdbc:hsql:foo")).isFalse();
        Assertions.assertThat((boolean)this.msSql.matchesJdbcURL("jdbc:mysql:foo")).isFalse();
    }

    @Test
    public void testBooleanSqlValues() {
        Assertions.assertThat((String)this.msSql.getTrueSqlValue()).isEqualTo((Object)"1");
        Assertions.assertThat((String)this.msSql.getFalseSqlValue()).isEqualTo((Object)"0");
    }

    @Test
    public void should_configure() {
        Assertions.assertThat((String)this.msSql.getId()).isEqualTo((Object)"mssql");
        Assertions.assertThat((String)this.msSql.getActiveRecordDialectCode()).isEqualTo((Object)"sqlserver");
        Assertions.assertThat((String)this.msSql.getDefaultDriverClassName()).isEqualTo((Object)"net.sourceforge.jtds.jdbc.Driver");
        Assertions.assertThat((String)this.msSql.getValidationQuery()).isEqualTo((Object)"SELECT 1");
    }
}

