/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.persistence.dialect;

import org.fest.assertions.Assertions;
import org.junit.Test;
import org.sonar.core.persistence.dialect.MySql;

public class MySqlTest {
    private MySql mySql = new MySql();

    @Test
    public void matchesJdbcURL() {
        Assertions.assertThat((boolean)this.mySql.matchesJdbcURL("jdbc:mysql://localhost:3306/sonar?useUnicode=true&characterEncoding=utf8")).isTrue();
        Assertions.assertThat((boolean)this.mySql.matchesJdbcURL("JDBC:MYSQL://localhost:3306/sonar?useUnicode=true&characterEncoding=utf8")).isTrue();
        Assertions.assertThat((boolean)this.mySql.matchesJdbcURL("jdbc:hsql:foo")).isFalse();
        Assertions.assertThat((boolean)this.mySql.matchesJdbcURL("jdbc:oracle:foo")).isFalse();
    }

    @Test
    public void testBooleanSqlValues() {
        Assertions.assertThat((String)this.mySql.getTrueSqlValue()).isEqualTo((Object)"true");
        Assertions.assertThat((String)this.mySql.getFalseSqlValue()).isEqualTo((Object)"false");
    }

    @Test
    public void should_configure() {
        Assertions.assertThat((String)this.mySql.getId()).isEqualTo((Object)"mysql");
        Assertions.assertThat((String)this.mySql.getActiveRecordDialectCode()).isEqualTo((Object)"mysql");
        Assertions.assertThat((String)this.mySql.getDefaultDriverClassName()).isEqualTo((Object)"com.mysql.jdbc.Driver");
        Assertions.assertThat((String)this.mySql.getValidationQuery()).isEqualTo((Object)"SELECT 1");
    }
}

