/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.plugins;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.sonar.core.plugins.RemotePlugin;

public class RemotePluginTest {
    @Test
    public void shouldEqual() {
        RemotePlugin clirr1 = new RemotePlugin("clirr", false);
        RemotePlugin clirr2 = new RemotePlugin("clirr", false);
        RemotePlugin checkstyle = new RemotePlugin("checkstyle", true);
        Assert.assertThat((Object)clirr1.equals((Object)clirr2), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)clirr1.equals((Object)clirr1), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)clirr1.equals((Object)checkstyle), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldMarshal() {
        RemotePlugin clirr = new RemotePlugin("clirr", false).addFilename("clirr-1.1.jar");
        String text = clirr.marshal();
        Assert.assertThat((Object)text, (Matcher)Is.is((Object)"clirr,false,clirr-1.1.jar"));
    }

    @Test
    public void shouldMarshalDeprecatedExtensions() {
        RemotePlugin checkstyle = new RemotePlugin("checkstyle", true);
        checkstyle.addFilename("checkstyle-2.8.jar");
        checkstyle.addFilename("ext.xml");
        checkstyle.addFilename("ext.jar");
        String text = checkstyle.marshal();
        Assert.assertThat((Object)text, (Matcher)Is.is((Object)"checkstyle,true,checkstyle-2.8.jar,ext.xml,ext.jar"));
    }

    @Test
    public void shouldUnmarshal() {
        RemotePlugin clirr = RemotePlugin.unmarshal((String)"clirr,false,clirr-1.1.jar");
        Assert.assertThat((Object)clirr.getKey(), (Matcher)Is.is((Object)"clirr"));
        Assert.assertThat((Object)clirr.isCore(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)clirr.getFilenames().size(), (Matcher)Is.is((Object)1));
        Assert.assertThat(clirr.getFilenames().get(0), (Matcher)Is.is((Object)"clirr-1.1.jar"));
    }

    @Test
    public void shouldUnmarshalDeprecatedExtensions() {
        RemotePlugin checkstyle = RemotePlugin.unmarshal((String)"checkstyle,true,checkstyle-2.8.jar,ext.xml,ext.jar");
        Assert.assertThat((Object)checkstyle.getKey(), (Matcher)Is.is((Object)"checkstyle"));
        Assert.assertThat((Object)checkstyle.isCore(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)checkstyle.getFilenames().size(), (Matcher)Is.is((Object)3));
        Assert.assertThat((Object)checkstyle.getFilenames(), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{"checkstyle-2.8.jar", "ext.xml", "ext.jar"}));
    }
}

