/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.properties;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.properties.PropertiesDao;
import org.sonar.core.properties.PropertyDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesDaoTest
extends AbstractDaoTestCase {
    private PropertiesDao dao;

    @Before
    public void createDao() {
        this.dao = new PropertiesDao(this.getMyBatis());
    }

    @Test
    public void shouldFindUserIdsForFavouriteResource() {
        this.setupData("shouldFindUserIdsForFavouriteResource");
        List userIds = this.dao.findUserIdsForFavouriteResource(Long.valueOf(2L));
        Assert.assertThat((Object)userIds.size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)userIds, (Matcher)Matchers.hasItems((Object[])new String[]{"user3", "user4"}));
    }

    @Test
    public void selectGlobalProperties() {
        this.setupData("selectGlobalProperties");
        List properties = this.dao.selectGlobalProperties();
        Assert.assertThat((Object)properties.size(), (Matcher)Matchers.is((Object)2));
        PropertyDto first = this.findById(properties, 1);
        Assert.assertThat((Object)first.getKey(), (Matcher)Matchers.is((Object)"global.one"));
        Assert.assertThat((Object)first.getValue(), (Matcher)Matchers.is((Object)"one"));
        PropertyDto second = this.findById(properties, 2);
        Assert.assertThat((Object)second.getKey(), (Matcher)Matchers.is((Object)"global.two"));
        Assert.assertThat((Object)second.getValue(), (Matcher)Matchers.is((Object)"two"));
    }

    @Test
    public void selectProjectProperties() {
        this.setupData("selectProjectProperties");
        List properties = this.dao.selectProjectProperties("org.struts:struts");
        Assert.assertThat((Object)properties.size(), (Matcher)Matchers.is((Object)1));
        PropertyDto first = (PropertyDto)properties.get(0);
        Assert.assertThat((Object)first.getKey(), (Matcher)Matchers.is((Object)"struts.one"));
        Assert.assertThat((Object)first.getValue(), (Matcher)Matchers.is((Object)"one"));
    }

    @Test
    public void setProperty_update() {
        this.setupData("update");
        this.dao.setProperty(new PropertyDto().setKey("global.key").setValue("new_global"));
        this.dao.setProperty(new PropertyDto().setKey("project.key").setResourceId(Long.valueOf(10L)).setValue("new_project"));
        this.dao.setProperty(new PropertyDto().setKey("user.key").setUserId(Long.valueOf(100L)).setValue("new_user"));
        this.dao.setProperty(new PropertyDto().setKey("null.value").setValue(null));
        this.checkTables("update", "properties");
    }

    @Test
    public void setProperty_insert() {
        this.setupData("insert");
        this.dao.setProperty(new PropertyDto().setKey("global.key").setValue("new_global"));
        this.dao.setProperty(new PropertyDto().setKey("project.key").setResourceId(Long.valueOf(10L)).setValue("new_project"));
        this.dao.setProperty(new PropertyDto().setKey("user.key").setUserId(Long.valueOf(100L)).setValue("new_user"));
        this.checkTables("insert", "properties");
    }

    @Test
    public void deleteGlobalProperties() {
        this.setupData("deleteGlobalProperties");
        this.dao.deleteGlobalProperties();
        this.checkTables("deleteGlobalProperties", "properties");
    }

    @Test
    public void deleteGlobalProperty() {
        this.setupData("deleteGlobalProperty");
        this.dao.deleteGlobalProperty("to_be_deleted");
        this.checkTables("deleteGlobalProperty", "properties");
    }

    @Test
    public void insertGlobalProperties() {
        this.setupData("insertGlobalProperties");
        this.dao.saveGlobalProperties((Map)ImmutableMap.of((Object)"to_be_inserted", (Object)"inserted"));
        this.checkTable("insertGlobalProperties", "properties", "prop_key", "text_value", "resource_id", "user_id");
    }

    @Test
    public void updateGlobalProperties() {
        this.setupData("updateGlobalProperties");
        this.dao.saveGlobalProperties((Map)ImmutableMap.of((Object)"to_be_updated", (Object)"updated"));
        this.checkTable("updateGlobalProperties", "properties", "prop_key", "text_value", "resource_id", "user_id");
    }

    private PropertyDto findById(List<PropertyDto> properties, int id) {
        for (PropertyDto property : properties) {
            if (property.getId() != (long)id) continue;
            return property;
        }
        return null;
    }
}

