/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.purge;

import java.util.Arrays;
import org.apache.ibatis.session.SqlSession;
import org.junit.Test;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.purge.PurgeCommands;
import org.sonar.core.purge.PurgeSnapshotQuery;

public class PurgeCommandsTest
extends AbstractDaoTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeleteSnapshot() {
        this.setupData("shouldDeleteSnapshot");
        SqlSession session = this.getMyBatis().openSession();
        try {
            new PurgeCommands(session).deleteSnapshots(PurgeSnapshotQuery.create().setId(Long.valueOf(5L)));
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
        this.checkTables("shouldDeleteSnapshot", "snapshots", "project_measures", "measure_data", "rule_failures", "snapshot_sources", "duplications_index", "events", "dependencies");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldPurgeSnapshot() {
        this.setupData("shouldPurgeSnapshot");
        SqlSession session = this.getMyBatis().openSession();
        try {
            new PurgeCommands(session).purgeSnapshots(PurgeSnapshotQuery.create().setId(Long.valueOf(1L)));
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
        this.checkTables("shouldPurgeSnapshot", "snapshots", "project_measures", "measure_data", "rule_failures", "snapshot_sources", "duplications_index", "events", "dependencies", "reviews");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeleteWastedMeasuresWhenPurgingSnapshot() {
        this.setupData("shouldDeleteWastedMeasuresWhenPurgingSnapshot");
        SqlSession session = this.getMyBatis().openSession();
        try {
            new PurgeCommands(session).purgeSnapshots(PurgeSnapshotQuery.create().setId(Long.valueOf(1L)));
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
        this.checkTables("shouldDeleteWastedMeasuresWhenPurgingSnapshot", "project_measures");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeleteResource() {
        this.setupData("shouldDeleteResource");
        SqlSession session = this.getMyBatis().openSession();
        try {
            new PurgeCommands(session).deleteResources(Arrays.asList(1L));
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
        this.assertEmptyTables("projects", "snapshots", "events", "reviews", "review_comments", "authors");
    }
}

