/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.purge;

import java.util.List;
import org.apache.ibatis.session.SqlSession;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.IsCollectionContaining;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.purge.PurgeDao;
import org.sonar.core.purge.PurgeMapper;
import org.sonar.core.purge.PurgeSnapshotQuery;
import org.sonar.core.purge.PurgeableSnapshotDto;
import org.sonar.core.resource.ResourceDao;

public class PurgeDaoTest
extends AbstractDaoTestCase {
    private PurgeDao dao;

    @Before
    public void createDao() {
        this.dao = new PurgeDao(this.getMyBatis(), new ResourceDao(this.getMyBatis()));
    }

    @Test
    public void shouldDeleteAbortedBuilds() {
        this.setupData("shouldDeleteAbortedBuilds");
        this.dao.purge(1L, new String[0]);
        this.checkTables("shouldDeleteAbortedBuilds", "snapshots");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldCloseReviewWhenDisablingResource() {
        this.setupData("shouldCloseReviewWhenDisablingResource");
        SqlSession session = this.getMyBatis().openSession();
        try {
            this.dao.disableResource(1L, (PurgeMapper)session.getMapper(PurgeMapper.class));
            session.commit();
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
        this.checkTables("shouldCloseReviewWhenDisablingResource", new String[]{"updated_at"}, new String[]{"reviews"});
    }

    @Test
    public void shouldPurgeProject() {
        this.setupData("shouldPurgeProject");
        this.dao.purge(1L, new String[0]);
        this.checkTables("shouldPurgeProject", "projects", "snapshots");
    }

    @Test
    public void shouldDeleteHistoricalDataOfDirectoriesAndFiles() {
        this.setupData("shouldDeleteHistoricalDataOfDirectoriesAndFiles");
        this.dao.purge(1L, new String[]{"DIR", "FIL"});
        this.checkTables("shouldDeleteHistoricalDataOfDirectoriesAndFiles", "projects", "snapshots");
    }

    @Test
    public void shouldDisableResourcesWithoutLastSnapshot() {
        this.setupData("shouldDisableResourcesWithoutLastSnapshot");
        this.dao.purge(1L, new String[0]);
        this.checkTables("shouldDisableResourcesWithoutLastSnapshot", "projects", "snapshots");
    }

    @Test
    public void shouldDeleteSnapshots() {
        this.setupData("shouldDeleteSnapshots");
        this.dao.deleteSnapshots(PurgeSnapshotQuery.create().setIslast(Boolean.valueOf(false)).setResourceId(Long.valueOf(1L)));
        this.checkTables("shouldDeleteSnapshots", "snapshots");
    }

    @Test
    public void shouldSelectPurgeableSnapshots() {
        this.setupData("shouldSelectPurgeableSnapshots");
        List snapshots = this.dao.selectPurgeableSnapshots(1L);
        Assert.assertThat((Object)snapshots, (Matcher)IsCollectionContaining.hasItem((Matcher)new SnapshotMatcher(1L, true, false)));
        Assert.assertThat((Object)snapshots, (Matcher)IsCollectionContaining.hasItem((Matcher)new SnapshotMatcher(4L, false, false)));
        Assert.assertThat((Object)snapshots, (Matcher)IsCollectionContaining.hasItem((Matcher)new SnapshotMatcher(5L, false, true)));
        Assert.assertThat((Object)snapshots.size(), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void shouldDeleteProject() {
        this.setupData("shouldDeleteProject");
        this.dao.deleteResourceTree(1L);
        this.assertEmptyTables("projects", "snapshots", "action_plans", "action_plans_reviews", "reviews", "review_comments");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SnapshotMatcher
    extends BaseMatcher<PurgeableSnapshotDto> {
        long snapshotId;
        boolean isLast;
        boolean hasEvents;

        SnapshotMatcher(long snapshotId, boolean last, boolean hasEvents) {
            this.snapshotId = snapshotId;
            this.isLast = last;
            this.hasEvents = hasEvents;
        }

        public boolean matches(Object o) {
            PurgeableSnapshotDto obj = (PurgeableSnapshotDto)o;
            return obj.getSnapshotId() == this.snapshotId && obj.isLast() == this.isLast && obj.hasEvents() == this.hasEvents;
        }

        public void describeTo(Description description) {
            description.appendText("snapshotId").appendValue((Object)this.snapshotId).appendText("isLast").appendValue((Object)this.isLast).appendText("hasEvents").appendValue((Object)this.hasEvents);
        }
    }
}

