/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.resource;

import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.resource.ResourceDao;
import org.sonar.core.resource.ResourceDto;
import org.sonar.core.resource.ResourceQuery;

public class ResourceDaoTest
extends AbstractDaoTestCase {
    private ResourceDao dao;

    @Before
    public void createDao() {
        this.dao = new ResourceDao(this.getMyBatis());
    }

    @Test
    public void testDescendantProjects_do_not_include_self() {
        this.setupData("fixture");
        List resources = this.dao.getDescendantProjects(1L);
        Assertions.assertThat((List)resources).onProperty("id").containsOnly(new Object[]{2L});
    }

    @Test
    public void testDescendantProjects_id_not_found() {
        this.setupData("fixture");
        List resources = this.dao.getDescendantProjects(33333L);
        Assertions.assertThat((List)resources).isEmpty();
    }

    @Test
    public void get_resource_by_id() {
        this.setupData("fixture");
        ResourceDto resource = this.dao.getResource(1L);
        Assertions.assertThat((String)resource.getName()).isEqualTo((Object)"Struts");
        Assertions.assertThat((String)resource.getLongName()).isEqualTo((Object)"Apache Struts");
        Assertions.assertThat((String)resource.getScope()).isEqualTo((Object)"PRJ");
        Assertions.assertThat((String)resource.getDescription()).isEqualTo((Object)"the description");
        Assertions.assertThat((String)resource.getLanguage()).isEqualTo((Object)"java");
        Assertions.assertThat((boolean)resource.isEnabled()).isTrue();
    }

    @Test
    public void getResource_not_found() {
        this.setupData("fixture");
        Assertions.assertThat((Object)this.dao.getResource(987654321L)).isNull();
    }

    @Test
    public void getResources_all() {
        this.setupData("fixture");
        List resources = this.dao.getResources(ResourceQuery.create());
        Assertions.assertThat((List)resources).hasSize(4);
    }

    @Test
    public void getResources_filter_by_qualifier() {
        this.setupData("fixture");
        List resources = this.dao.getResources(ResourceQuery.create().setQualifiers(new String[]{"TRK", "BRC"}));
        Assertions.assertThat((List)resources).onProperty("qualifier").containsOnly(new Object[]{"TRK", "BRC"});
        resources = this.dao.getResources(ResourceQuery.create().setQualifiers(new String[]{"XXX"}));
        Assertions.assertThat((List)resources).isEmpty();
        resources = this.dao.getResources(ResourceQuery.create().setQualifiers(new String[0]));
        Assertions.assertThat((List)resources).hasSize(4);
    }

    @Test
    public void getResources_filter_by_key() {
        this.setupData("fixture");
        ResourceQuery query = ResourceQuery.create().setKey("org.struts:struts-core");
        List resources = this.dao.getResources(query);
        Assertions.assertThat((List)resources).hasSize(1);
        Assertions.assertThat((String)((ResourceDto)resources.get(0)).getKey()).isEqualTo((Object)"org.struts:struts-core");
        Assertions.assertThat((String)this.dao.getResource(query).getKey()).isEqualTo((Object)"org.struts:struts-core");
    }

    @Test
    public void getResourceIds_all() {
        this.setupData("fixture");
        List ids = this.dao.getResourceIds(ResourceQuery.create());
        Assertions.assertThat((List)ids).hasSize(4);
    }

    @Test
    public void getResourceIds_filter_by_qualifier() {
        this.setupData("fixture");
        List ids = this.dao.getResourceIds(ResourceQuery.create().setQualifiers(new String[]{"TRK", "BRC"}));
        Assertions.assertThat((List)ids).containsOnly(new Object[]{1L, 2L});
        ids = this.dao.getResourceIds(ResourceQuery.create().setQualifiers(new String[]{"XXX"}));
        Assertions.assertThat((List)ids).isEmpty();
        ids = this.dao.getResourceIds(ResourceQuery.create().setQualifiers(new String[0]));
        Assertions.assertThat((List)ids).hasSize(4);
    }

    @Test
    public void getResources_exclude_disabled() {
        this.setupData("getResources_exclude_disabled");
        Assertions.assertThat((List)this.dao.getResourceIds(ResourceQuery.create().setExcludeDisabled(false))).containsOnly(new Object[]{1L, 2L});
        Assertions.assertThat((List)this.dao.getResourceIds(ResourceQuery.create().setExcludeDisabled(true))).containsOnly(new Object[]{2L});
    }

    @Test
    public void should_update() {
        this.setupData("update");
        ResourceDto project = new ResourceDto().setKey("org.struts:struts").setScope("PRJ").setQualifier("TRK").setName("Struts").setLongName("Apache Struts").setLanguage("java").setDescription("MVC Framework").setId(Long.valueOf(1L));
        this.dao.insertOrUpdate(new ResourceDto[]{project});
        Assertions.assertThat((Long)project.getId()).isNotNull();
        this.checkTables("update", "projects");
    }

    @Test
    public void should_insert() {
        this.setupData("insert");
        ResourceDto file1 = new ResourceDto().setKey("org.struts:struts:org.struts.Action").setScope("FIL").setQualifier("FIL").setLanguage("java").setName("Action").setLongName("org.struts.Action");
        ResourceDto file2 = new ResourceDto().setKey("org.struts:struts:org.struts.Filter").setScope("FIL").setQualifier("FIL").setLanguage("java").setName("Filter").setLongName("org.struts.Filter");
        this.dao.insertOrUpdate(new ResourceDto[]{file1, file2});
        Assertions.assertThat((Long)file1.getId()).isNotNull();
        Assertions.assertThat((Long)file2.getId()).isNotNull();
        this.checkTables("insert", new String[]{"created_at"}, new String[]{"projects"});
        ResourceDto fileLoadedFromDB = this.dao.getResource(file1.getId().longValue());
        Assertions.assertThat((Object)fileLoadedFromDB.getCreatedAt()).isNotNull();
    }
}

