/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.resource;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.number.OrderingComparisons;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.resource.ResourceIndexerDao;

public class ResourceIndexerDaoTest
extends AbstractDaoTestCase {
    private static ResourceIndexerDao dao;

    @Before
    public void createDao() {
        dao = new ResourceIndexerDao(this.getMyBatis());
    }

    @Test
    public void shouldIndexResource() {
        this.setupData("shouldIndexResource");
        dao.indexResource(10, "ZipUtils", "FIL", 8);
        this.checkTables("shouldIndexResource", new String[]{"id"}, new String[]{"resource_index"});
    }

    @Test
    public void shouldIndexProjects() {
        this.setupData("shouldIndexProjects");
        dao.indexProjects();
        this.checkTables("shouldIndexProjects", new String[]{"id"}, new String[]{"resource_index"});
    }

    @Test
    public void shouldIndexMultiModulesProject() {
        this.setupData("shouldIndexMultiModulesProject");
        dao.indexProject(1);
        this.checkTables("shouldIndexMultiModulesProject", new String[]{"id"}, new String[]{"resource_index"});
    }

    @Test
    public void shouldReindexProjectAfterRenaming() {
        this.setupData("shouldReindexProjectAfterRenaming");
        dao.indexProject(1);
        this.checkTables("shouldReindexProjectAfterRenaming", new String[]{"id"}, new String[]{"resource_index"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotIndexPackages() throws SQLException {
        this.setupData("shouldNotIndexPackages");
        dao.indexProject(1);
        Connection connection = this.getConnection();
        ResultSet rs = null;
        try {
            rs = connection.createStatement().executeQuery("select count(resource_id) from resource_index where resource_id=1");
            rs.next();
            Assert.assertThat((Object)rs.getInt(1), (Matcher)OrderingComparisons.greaterThan((Comparable)Integer.valueOf(0)));
            rs = connection.createStatement().executeQuery("select count(resource_id) from resource_index where resource_id=2");
            rs.next();
            Assert.assertThat((Object)rs.getInt(1), (Matcher)Is.is((Object)0));
            rs = connection.createStatement().executeQuery("select count(resource_id) from resource_index where resource_id=3");
            rs.next();
            Assert.assertThat((Object)rs.getInt(1), (Matcher)OrderingComparisons.greaterThan((Comparable)Integer.valueOf(0)));
        }
        finally {
            if (null != rs) {
                rs.close();
            }
            connection.close();
        }
    }

    @Test
    public void shouldNotIndexWhenTooShortName() {
        this.setupData("empty");
        dao.indexResource(10, "AB", "FIL", 3);
        this.checkTables("empty", new String[]{"id"}, new String[]{"resource_index"});
    }

    @Test
    public void shouldReindexResource() {
        this.setupData("shouldReindexResource");
        dao.indexResource(1, "New Struts", "TRK", 1);
        this.checkTables("shouldReindexResource", new String[]{"id"}, new String[]{"resource_index"});
    }

    @Test
    public void shouldNotReindexUnchangedResource() {
        this.setupData("shouldNotReindexUnchangedResource");
        dao.indexResource(1, "Struts", "TRK", 1);
        this.checkTables("shouldNotReindexUnchangedResource", new String[]{"id"}, new String[]{"resource_index"});
    }
}

