/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.rule;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.rules.Rule;
import org.sonar.core.rule.CacheRuleFinder;
import org.sonar.jpa.test.AbstractDbUnitTestCase;

public class CacheRuleFinderTest
extends AbstractDbUnitTestCase {
    @Test
    public void shouldCacheFindById() {
        this.setupData("shared");
        CacheRuleFinder finder = new CacheRuleFinder(this.getSessionFactory());
        Assert.assertThat((Object)finder.findById(3).getConfigKey(), (Matcher)Is.is((Object)"Checker/Treewalker/AnnotationUseStyleCheck"));
        this.deleteRules();
        Assert.assertThat((Object)finder.findById(3), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void shouldNotFailIfUnknownRuleId() {
        this.setupData("shared");
        CacheRuleFinder finder = new CacheRuleFinder(this.getSessionFactory());
        Assert.assertThat((Object)finder.findById(33456816), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldCacheFindByKey() {
        this.setupData("shared");
        CacheRuleFinder finder = new CacheRuleFinder(this.getSessionFactory());
        Rule rule = finder.findByKey("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck");
        Assert.assertThat((Object)rule.getConfigKey(), (Matcher)Is.is((Object)"Checker/Treewalker/AnnotationUseStyleCheck"));
        this.deleteRules();
        rule = finder.findByKey("checkstyle", "com.puppycrawl.tools.checkstyle.checks.annotation.AnnotationUseStyleCheck");
        Assert.assertThat((Object)rule, (Matcher)IsNull.notNullValue());
    }

    private void deleteRules() {
        this.getSession().createQuery("delete " + Rule.class.getSimpleName()).executeUpdate();
        this.getSession().commit();
    }
}

