/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.rule;

import java.util.Collection;
import org.fest.assertions.Assertions;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleQuery;
import org.sonar.core.rule.DefaultRuleFinder;
import org.sonar.jpa.test.AbstractDbUnitTestCase;

public class DefaultRuleFinderTest
extends AbstractDbUnitTestCase {
    @Test
    public void shouldFindById() {
        this.setupData("shared");
        DefaultRuleFinder finder = new DefaultRuleFinder(this.getSessionFactory());
        Assert.assertThat((Object)finder.findById(3).getConfigKey(), (Matcher)Is.is((Object)"Checker/Treewalker/AnnotationUseStyleCheck"));
    }

    @Test
    public void shouldNotFindDisabledRuleById() {
        this.setupData("shared");
        DefaultRuleFinder finder = new DefaultRuleFinder(this.getSessionFactory());
        Assert.assertThat((Object)finder.findById(2), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldFindByKey() {
        this.setupData("shared");
        DefaultRuleFinder finder = new DefaultRuleFinder(this.getSessionFactory());
        Rule rule = finder.findByKey("checkstyle", "com.puppycrawl.tools.checkstyle.checks.header.HeaderCheck");
        Assert.assertNotNull((Object)rule);
        Assert.assertThat((Object)rule.getKey(), (Matcher)Is.is((Object)"com.puppycrawl.tools.checkstyle.checks.header.HeaderCheck"));
        Assert.assertThat((Object)rule.isEnabled(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void findShouldReturnNullIfNoResults() {
        this.setupData("shared");
        DefaultRuleFinder finder = new DefaultRuleFinder(this.getSessionFactory());
        Assert.assertNull((Object)finder.findByKey("checkstyle", "unknown"));
        Assert.assertNull((Object)finder.find(RuleQuery.create().withRepositoryKey("checkstyle").withConfigKey("unknown")));
    }

    @Test
    public void findRepositoryRules() {
        this.setupData("shared");
        DefaultRuleFinder finder = new DefaultRuleFinder(this.getSessionFactory());
        Collection rules = finder.findAll(RuleQuery.create().withRepositoryKey("checkstyle"));
        Assertions.assertThat((Collection)rules).hasSize(2);
    }

    @Test
    public void findAllEnabled() {
        this.setupData("shared");
        DefaultRuleFinder finder = new DefaultRuleFinder(this.getSessionFactory());
        Collection rules = finder.findAll(RuleQuery.create());
        Assertions.assertThat((Collection)rules).onProperty("id").containsOnly(new Object[]{1, 3, 4});
    }

    @Test
    public void doNotFindDisabledRules() {
        this.setupData("shared");
        DefaultRuleFinder finder = new DefaultRuleFinder(this.getSessionFactory());
        Rule rule = finder.findByKey("checkstyle", "DisabledCheck");
        Assert.assertNull((Object)rule);
    }

    @Test
    public void doNotFindUnknownRules() {
        this.setupData("shared");
        DefaultRuleFinder finder = new DefaultRuleFinder(this.getSessionFactory());
        Collection rules = finder.findAll(RuleQuery.create().withRepositoryKey("unknown_repository"));
        Assert.assertThat((Object)rules.size(), (Matcher)Is.is((Object)0));
    }
}

