/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.user;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.user.AuthorDao;
import org.sonar.core.user.AuthorDto;

public class AuthorDaoTest
extends AbstractDaoTestCase {
    private AuthorDao dao;

    @Before
    public void setUp() {
        this.dao = new AuthorDao(this.getMyBatis());
    }

    @Test
    public void shouldSelectByLogin() {
        this.setupData("shouldSelectByLogin");
        AuthorDto authorDto = this.dao.selectByLogin("godin");
        Assert.assertThat((Object)authorDto.getId(), (Matcher)Matchers.is((Object)1L));
        Assert.assertThat((Object)authorDto.getPersonId(), (Matcher)Matchers.is((Object)13L));
        Assert.assertThat((Object)authorDto.getLogin(), (Matcher)Matchers.is((Object)"godin"));
        Assert.assertThat((Object)this.dao.selectByLogin("simon"), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    public void shouldInsert() {
        this.setupData("shouldInsert");
        AuthorDto authorDto = new AuthorDto().setLogin("godin").setPersonId(Long.valueOf(13L));
        this.dao.insert(authorDto);
        this.checkTables("shouldInsert", new String[]{"created_at", "updated_at"}, new String[]{"authors"});
    }

    @Test
    public void countDeveloperLogins() {
        this.setupData("countDeveloperLogins");
        Assert.assertThat((Object)this.dao.countDeveloperLogins(1L), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)this.dao.countDeveloperLogins(98765L), (Matcher)Matchers.is((Object)0));
    }
}

