/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.user;

import org.apache.ibatis.session.SqlSession;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.persistence.MyBatis;
import org.sonar.core.user.GroupRoleDto;
import org.sonar.core.user.RoleMapper;
import org.sonar.core.user.UserRoleDto;

public class RoleMapperTest
extends AbstractDaoTestCase {
    private SqlSession session;

    @Before
    public void openSession() {
        this.session = this.getMyBatis().openSession();
    }

    @After
    public void closeSession() {
        MyBatis.closeQuietly((SqlSession)this.session);
    }

    @Test
    public void countRoles() {
        this.setupData("countRoles");
        RoleMapper mapper = (RoleMapper)this.session.getMapper(RoleMapper.class);
        Assertions.assertThat((int)mapper.countGroupRoles(Long.valueOf(123L))).isEqualTo(2);
        Assertions.assertThat((int)mapper.countUserRoles(Long.valueOf(123L))).isEqualTo(1);
    }

    @Test
    public void deleteRolesByResourceId() {
        this.setupData("deleteRolesByResourceId");
        RoleMapper mapper = (RoleMapper)this.session.getMapper(RoleMapper.class);
        mapper.deleteGroupRolesByResourceId(Long.valueOf(123L));
        mapper.deleteUserRolesByResourceId(Long.valueOf(123L));
        this.session.commit();
        this.checkTables("deleteRolesByResourceId", "group_roles", "user_roles");
    }

    @Test
    public void insertRoles() {
        this.setupData("insertRoles");
        RoleMapper mapper = (RoleMapper)this.session.getMapper(RoleMapper.class);
        mapper.insertGroupRole(new GroupRoleDto().setRole("admin").setGroupId(Long.valueOf(100L)).setResourceId(Long.valueOf(123L)));
        mapper.insertGroupRole(new GroupRoleDto().setRole("user").setResourceId(Long.valueOf(123L)));
        mapper.insertUserRole(new UserRoleDto().setRole("codeviewer").setUserId(Long.valueOf(200L)).setResourceId(Long.valueOf(123L)));
        this.session.commit();
        this.checkTables("insertRoles", "group_roles", "user_roles");
    }
}

