/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.user;

import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.user.GroupDto;
import org.sonar.core.user.UserDao;
import org.sonar.core.user.UserDto;

public class UserDaoTest
extends AbstractDaoTestCase {
    private UserDao dao;

    @Before
    public void setUp() {
        this.dao = new UserDao(this.getMyBatis());
    }

    @Test
    public void selectUserByLogin_ignore_same_disabled_login() {
        this.setupData("selectUserByLogin");
        UserDto user = this.dao.selectUserByLogin("marius");
        Assertions.assertThat((Object)user).isNotNull();
        Assertions.assertThat((Long)user.getId()).isEqualTo(101L);
        Assertions.assertThat((String)user.getLogin()).isEqualTo((Object)"marius");
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Marius");
        Assertions.assertThat((String)user.getEmail()).isEqualTo((Object)"marius@lesbronzes.fr");
        Assertions.assertThat((Object)user.getCreatedAt()).isNotNull();
        Assertions.assertThat((Object)user.getUpdatedAt()).isNotNull();
        Assertions.assertThat((boolean)user.isEnabled()).isTrue();
    }

    @Test
    public void selectUserByLogin_ignore_disabled() {
        this.setupData("selectUserByLogin");
        UserDto user = this.dao.selectUserByLogin("disabled");
        Assertions.assertThat((Object)user).isNull();
    }

    @Test
    public void selectUserByLogin_not_found() {
        this.setupData("selectUserByLogin");
        UserDto user = this.dao.selectUserByLogin("not_found");
        Assertions.assertThat((Object)user).isNull();
    }

    @Test
    public void selectGroupByName() {
        this.setupData("selectGroupByName");
        GroupDto group = this.dao.selectGroupByName("sonar-users");
        Assertions.assertThat((Object)group).isNotNull();
        Assertions.assertThat((Long)group.getId()).isEqualTo(1L);
        Assertions.assertThat((String)group.getName()).isEqualTo((Object)"sonar-users");
        Assertions.assertThat((String)group.getDescription()).isEqualTo((Object)"Sonar Users");
        Assertions.assertThat((Object)group.getCreatedAt()).isNotNull();
        Assertions.assertThat((Object)group.getUpdatedAt()).isNotNull();
    }

    @Test
    public void selectGroupByName_not_found() {
        this.setupData("selectGroupByName");
        GroupDto group = this.dao.selectGroupByName("not-found");
        Assertions.assertThat((Object)group).isNull();
    }
}

