/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.workflow;

import java.util.Arrays;
import java.util.Date;
import org.fest.assertions.Assertions;
import org.junit.Test;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.workflow.Comment;
import org.sonar.api.workflow.internal.DefaultReview;
import org.sonar.core.persistence.AbstractDaoTestCase;
import org.sonar.core.workflow.ReviewDatabaseStore;

public class ReviewDatabaseStoreTest
extends AbstractDaoTestCase {
    @Test
    public void store() {
        this.setupData("store");
        ReviewDatabaseStore store = new ReviewDatabaseStore(this.getMyBatis());
        DefaultReview review = new DefaultReview().setReviewId(Long.valueOf(1234L));
        review.setStatus("CLOSED");
        review.setResolution("RESOLVED");
        review.setProperty("who", "me");
        review.setProperty("why", "because");
        Comment comment = review.createComment();
        comment.setMarkdownText("this is a comment");
        comment.setUserId(Long.valueOf(555L));
        Date now = DateUtils.parseDate((String)"2012-05-18");
        store.store(review, now);
        this.checkTables("store", "reviews");
        this.checkTables("store", new String[]{"id"}, new String[]{"review_comments"});
    }

    @Test
    public void completeProjectSettings() {
        this.setupData("completeProjectSettings");
        ReviewDatabaseStore store = new ReviewDatabaseStore(this.getMyBatis());
        Settings settings = new Settings();
        store.completeProjectSettings(Long.valueOf(100L), settings, Arrays.asList("not.available.on.project", "jira.project.key"));
        Assertions.assertThat((String)settings.getString("not.available.on.project")).isNull();
        Assertions.assertThat((String)settings.getString("jira.project.key")).isEqualTo((Object)"FOO");
    }
}

