/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dao;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.measures.Metric;
import org.sonar.jpa.dao.MeasuresDao;
import org.sonar.jpa.test.AbstractDbUnitTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasuresDaoTest
extends AbstractDbUnitTestCase {
    private MeasuresDao service;
    private ResourceModel project;

    @Before
    public void before() throws Exception {
        this.service = new MeasuresDao(this.getSession());
        this.project = new ResourceModel("PRJ", "foo:bar", "TRK", null, "Foo");
        this.project.setName("project name");
        this.getSession().save((Object)this.project);
    }

    @Test
    public void shouldReturnUserDefinedMetrics() {
        for (Metric metric : this.createMetrics()) {
            this.getSession().save((Object)metric);
        }
        Collection metrics = this.service.getUserDefinedMetrics();
        Assert.assertThat((Object)metrics.size(), (Matcher)Matchers.is((Object)2));
        for (Metric metric : metrics) {
            Assert.assertThat((Object)metric.getOrigin(), (Matcher)Matchers.not((Object)Metric.Origin.JAV));
        }
    }

    @Test
    public void shouldRegisterMetrics() {
        Collection<Metric> newMetrics = this.createMetrics();
        this.service.registerMetrics(newMetrics);
        Collection metrics = this.service.getEnabledMetrics();
        Assert.assertThat((Object)metrics.size(), (Matcher)Matchers.is((Object)newMetrics.size()));
    }

    @Test
    public void shouldDisabledMetrics() {
        Collection<Metric> newMetrics = this.createMetrics();
        this.service.disabledMetrics(newMetrics);
        Collection allMetrics = this.service.getMetrics();
        Assert.assertThat((Object)allMetrics.size(), (Matcher)Matchers.is((Object)newMetrics.size()));
        Collection disabledMetrics = this.service.getEnabledMetrics();
        Assert.assertThat((Object)disabledMetrics.size(), (Matcher)Matchers.is((Object)0));
    }

    private Collection<Metric> createMetrics() {
        Metric m1 = new Metric("metric1");
        m1.setEnabled(Boolean.valueOf(false));
        m1.setOrigin(Metric.Origin.JAV);
        Metric m2 = new Metric("metric2");
        m2.setEnabled(Boolean.valueOf(true));
        m2.setOrigin(Metric.Origin.JAV);
        Metric m3 = new Metric("metric3");
        m3.setEnabled(Boolean.valueOf(false));
        m3.setOrigin(Metric.Origin.GUI);
        Metric m4 = new Metric("metric4");
        m4.setEnabled(Boolean.valueOf(true));
        m4.setOrigin(Metric.Origin.GUI);
        Metric m5 = new Metric("metric5");
        m5.setEnabled(Boolean.valueOf(true));
        m5.setOrigin(Metric.Origin.WS);
        return Arrays.asList(m1, m2, m3, m4, m5);
    }
}

