/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.dao;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.sonar.api.rules.Rule;
import org.sonar.jpa.dao.RulesDao;
import org.sonar.jpa.test.AbstractDbUnitTestCase;

public class RulesDaoTest
extends AbstractDbUnitTestCase {
    private RulesDao rulesDao;

    @Before
    public void setup() {
        this.rulesDao = new RulesDao(this.getSession());
    }

    @Test
    public void shouldGetRules() {
        this.setupData("shouldGetRules");
        List rules = this.rulesDao.getRules();
        Assert.assertThat((Object)rules, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)rules.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertEquals((Object)"rule_one", (Object)((Rule)rules.get(0)).getKey());
        Assert.assertEquals((long)1L, (long)((Rule)rules.get(0)).getParams().size());
    }

    @Test
    public void shouldGetRuleWithRuleKeyAndPluginKey() {
        this.setupData("shouldGetRuleWithRuleKeyAndPluginKey");
        Rule rule = this.rulesDao.getRuleByKey("plugin", "checkstyle.rule1");
        Assert.assertThat((Object)rule, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)rule.getId(), (Matcher)CoreMatchers.notNullValue());
        Rule rule2 = this.rulesDao.getRuleByKey("plugin", "key not found");
        Assert.assertThat((Object)rule2, (Matcher)CoreMatchers.nullValue());
    }
}

