/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import java.util.Date;
import java.util.List;
import javax.persistence.NonUniqueResultException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.IsCollectionContaining;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.ResourceModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.jpa.dao.MeasuresDao;
import org.sonar.jpa.test.AbstractDbUnitTestCase;

public class DatabaseSessionTest
extends AbstractDbUnitTestCase {
    private static final Long NB_INSERTS = 20000L;
    private ResourceModel project1;
    private ResourceModel project2;

    @Before
    public void setup() {
        this.project1 = new ResourceModel("PRJ", "mygroup:myartifact", "JAV", null, "my name");
        this.project2 = new ResourceModel("PRJ", "mygroup:myartifact1", "JAV", null, "my name 2");
    }

    @Test
    public void performanceTestOnBatchInserts() throws Exception {
        this.getSession().save((Object)this.project1);
        Snapshot snapshot = new Snapshot(this.project1, true, "", (Date)new java.sql.Date(1L));
        this.getSession().save((Object)snapshot);
        this.getSession().save((Object)CoreMetrics.CLASSES);
        this.getSession().commit();
        Metric metric = new MeasuresDao(this.getSession()).getMetric("classes");
        int i = 0;
        while ((long)i < NB_INSERTS) {
            MeasureModel pm = new MeasureModel(metric.getId().intValue(), Double.valueOf(1.0)).setSnapshotId(snapshot.getId());
            this.getSession().save((Object)pm);
            ++i;
        }
        this.getSession().commit();
        Assert.assertEquals((Object)NB_INSERTS, (Object)this.getHQLCount(MeasureModel.class));
    }

    @Test
    public void testGetSingleResultWithNoResults() {
        Assert.assertNull((Object)this.getSession().getSingleResult(ResourceModel.class, new Object[]{"name", "test"}));
    }

    @Test
    public void testGetSingleResultWithNoCriterias() {
        try {
            Assert.assertNull((Object)this.getSession().getSingleResult(ResourceModel.class, (Object[])null));
            Assert.fail((String)"No IllegalStateException raised");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSingleResultWithOneResult() {
        this.getSession().save((Object)this.project1);
        ResourceModel hit = (ResourceModel)this.getSession().getSingleResult(ResourceModel.class, new Object[]{"name", "my name"});
        Assert.assertNotNull((Object)hit);
        Assert.assertEquals((Object)this.project1, (Object)hit);
    }

    @Test
    public void testGetSingleResultWithTwoResults() {
        this.getSession().save(new Object[]{this.project1, this.project2});
        try {
            this.getSession().getSingleResult(ResourceModel.class, new Object[]{"qualifier", "JAV"});
            Assert.fail((String)"No NonUniqueResultException raised");
        }
        catch (NonUniqueResultException nonUniqueResultException) {
            // empty catch block
        }
    }

    @Test
    public void testGetResultsWithNoResults() {
        List hits = this.getSession().getResults(ResourceModel.class, new Object[]{"name", "foo"});
        Assert.assertTrue((boolean)hits.isEmpty());
    }

    @Test
    public void testGetResultsWithMultipleResults() {
        ResourceModel project3 = new ResourceModel("PRJ", "mygroup:myartifact3", "BRC", null, "my name 3");
        this.getSession().save(new Object[]{this.project1, this.project2, project3});
        List hits = this.getSession().getResults(ResourceModel.class, new Object[]{"qualifier", "JAV"});
        Assert.assertFalse((boolean)hits.isEmpty());
        Assert.assertThat((Object)hits, (Matcher)IsCollectionContaining.hasItems((Object[])new ResourceModel[]{this.project1, this.project2}));
        Assert.assertThat((Object)hits, (Matcher)Matchers.not((Matcher)IsCollectionContaining.hasItem((Object)project3)));
    }
}

