/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.jpa.session;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.jpa.session.JpaDatabaseSession;

public class JpaDatabaseSessionTest {
    private JpaDatabaseSession session;

    @Before
    public void setUp() {
        this.session = new JpaDatabaseSession(null);
    }

    @Test(expected=NonUniqueResultException.class)
    public void shouldThrowNonUniqueResultException() {
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)query.getResultList()).thenReturn(Arrays.asList("foo", "bar"));
        this.session.getSingleResult(query, null);
    }

    @Test
    public void shouldReturnSingleResult() {
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)query.getResultList()).thenReturn(Arrays.asList("foo", "foo"), (Object[])new List[]{Arrays.asList("bar")});
        Assert.assertThat((Object)this.session.getSingleResult(query, (Object)"default"), (Matcher)Matchers.is((Object)"foo"));
        Assert.assertThat((Object)this.session.getSingleResult(query, (Object)"default"), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void shouldReturnDefaultValue() {
        Query query = (Query)Mockito.mock(Query.class);
        Mockito.when((Object)query.getResultList()).thenReturn(Collections.emptyList());
        Assert.assertThat((Object)this.session.getSingleResult(query, (Object)"default"), (Matcher)Matchers.is((Object)"default"));
    }

    @Test
    public void shouldBuildCriteriasHQL() {
        StringBuilder hql = new StringBuilder();
        HashMap mappedCriterias = Maps.newHashMap();
        mappedCriterias.put("foo", "value");
        mappedCriterias.put("bar", null);
        this.session.buildCriteriasHQL(hql, (Map)mappedCriterias);
        Assert.assertThat((Object)hql.toString(), (Matcher)Matchers.is((Object)"o.foo=:foo AND o.bar IS NULL"));
    }
}

