/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.PropertyField;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyFieldDefinition {
    private final String key;
    private final String name;
    private final String description;
    private final int indicativeSize;
    private final PropertyType type;
    private final String[] options;

    private PropertyFieldDefinition(PropertyField annotation) {
        this.key = annotation.key();
        this.name = annotation.name();
        this.description = annotation.description();
        this.indicativeSize = annotation.indicativeSize();
        this.type = annotation.type();
        this.options = annotation.options();
    }

    public static List<PropertyFieldDefinition> create(PropertyField[] fields) {
        ArrayList definitions = Lists.newArrayList();
        for (PropertyField field : fields) {
            definitions.add(new PropertyFieldDefinition(field));
        }
        return definitions;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getIndicativeSize() {
        return this.indicativeSize;
    }

    public PropertyType getType() {
        return this.type;
    }

    public String[] getOptions() {
        return (String[])this.options.clone();
    }

    public PropertyDefinition.Result validate(@Nullable String value) {
        return PropertyDefinition.validate(this.type, value, this.options);
    }
}

