/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import java.util.SortedSet;
import java.util.TreeSet;
import org.sonar.updatecenter.common.Release;
import org.sonar.updatecenter.common.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Artifact
implements Comparable<Artifact> {
    protected String key;
    protected SortedSet<Release> releases = new TreeSet<Release>();

    protected Artifact(String key) {
        this.key = key;
    }

    public final String getKey() {
        return this.key;
    }

    public final Artifact setKey(String key) {
        this.key = key;
        return this;
    }

    public final Release addRelease(Release release) {
        this.releases.add(release);
        return release;
    }

    public final Release addRelease(Version version) {
        return this.addRelease(new Release(this, version));
    }

    public final Release getRelease(Version version) {
        for (Release release : this.getReleases()) {
            if (!release.getVersion().equals(version)) continue;
            return release;
        }
        return null;
    }

    public final SortedSet<Release> getReleases() {
        return this.releases;
    }

    public final SortedSet<Release> getReleasesGreaterThan(String version) {
        return this.getReleasesGreaterThan(Version.create(version));
    }

    public final SortedSet<Release> getReleasesGreaterThan(Version version) {
        TreeSet<Release> result = new TreeSet<Release>();
        for (Release release : this.releases) {
            if (release.getVersion().compareTo(version) <= 0) continue;
            result.add(release);
        }
        return result;
    }

    public final SortedSet<Version> getVersions() {
        TreeSet<Version> versions = new TreeSet<Version>();
        for (Release release : this.releases) {
            versions.add(release.getVersion());
        }
        return versions;
    }

    public final Release getLastRelease() {
        return this.releases.isEmpty() ? null : this.releases.last();
    }

    public final Release getLastCompatibleRelease(Version sonarVersion) {
        Release result = null;
        for (Release r : this.releases) {
            if (!r.supportSonarVersion(sonarVersion)) continue;
            result = r;
        }
        return result;
    }

    public final Release getLastCompatibleReleaseIfUpgrade(Version sonarVersion) {
        Release result = null;
        for (Release r : this.releases) {
            if (r.getLastRequiredSonarVersion() == null || r.getLastRequiredSonarVersion().compareTo(sonarVersion) < 0) continue;
            result = r;
        }
        return result;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        return this.key.equals(artifact.key);
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public final int compareTo(Artifact other) {
        if (this.key == null) {
            return -1;
        }
        return this.key.compareTo(other.key);
    }
}

