/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.updatecenter.common;

import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Version
implements Comparable<Version> {
    private String normalizedMajor = Version.normalizePart("0");
    private String normalizedMinor = Version.normalizePart("0");
    private String normalizedPatch = Version.normalizePart("0");
    private String normalizedPatch2 = Version.normalizePart("0");
    private String major = "0";
    private String minor = "0";
    private String patch = "0";
    private String patch2 = "0";
    private String qualifier;
    private String name;

    private Version(String version) {
        this.name = StringUtils.trimToEmpty((String)version);
        this.qualifier = StringUtils.substringAfter((String)this.name, (String)"-");
        String numbers = StringUtils.substringBefore((String)this.name, (String)"-");
        String[] split = StringUtils.split((String)numbers, (char)'.');
        if (split.length >= 1) {
            this.major = split[0];
            this.normalizedMajor = Version.normalizePart(this.major);
        }
        if (split.length >= 2) {
            this.minor = split[1];
            this.normalizedMinor = Version.normalizePart(this.minor);
        }
        if (split.length >= 3) {
            this.patch = split[2];
            this.normalizedPatch = Version.normalizePart(this.patch);
        }
        if (split.length >= 4) {
            this.patch2 = split[3];
            this.normalizedPatch2 = Version.normalizePart(this.patch2);
        }
    }

    private static String normalizePart(String part) {
        return StringUtils.leftPad((String)part, (int)4, (char)'0');
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getPatch() {
        return this.patch;
    }

    public String getPatch2() {
        return this.patch2;
    }

    public String getName() {
        return this.name;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version other = (Version)o;
        if (!this.normalizedMajor.equals(other.normalizedMajor)) {
            return false;
        }
        if (!this.normalizedMinor.equals(other.normalizedMinor)) {
            return false;
        }
        if (!this.normalizedPatch.equals(other.normalizedPatch)) {
            return false;
        }
        if (!this.normalizedPatch2.equals(other.normalizedPatch2)) {
            return false;
        }
        return this.qualifier.equals(other.qualifier);
    }

    public int hashCode() {
        int result = this.normalizedMajor.hashCode();
        result = 31 * result + this.normalizedMinor.hashCode();
        result = 31 * result + this.normalizedPatch.hashCode();
        result = 31 * result + this.normalizedPatch2.hashCode();
        result = 31 * result + this.qualifier.hashCode();
        return result;
    }

    @Override
    public int compareTo(Version other) {
        int c = this.normalizedMajor.compareTo(other.normalizedMajor);
        if (c == 0 && (c = this.normalizedMinor.compareTo(other.normalizedMinor)) == 0 && (c = this.normalizedPatch.compareTo(other.normalizedPatch)) == 0) {
            c = this.normalizedPatch2.compareTo(other.normalizedPatch2);
        }
        if (c == 0) {
            c = "".equals(this.qualifier) ? ("".equals(other.qualifier) ? 0 : 1) : ("".equals(other.qualifier) ? -1 : this.qualifier.compareTo(other.qualifier));
        }
        return c;
    }

    public String toString() {
        return this.name;
    }

    public static Version create(String version) {
        return new Version(version);
    }

    public static Version createRelease(String version) {
        return new Version(StringUtils.substringBefore((String)version, (String)"-"));
    }
}

