/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.tests;

import com.sonar.sslr.api.Rule;
import org.fest.assertions.GenericAssert;
import org.sonar.sslr.internal.matchers.GrammarElementMatcher;
import org.sonar.sslr.parser.GrammarOperators;
import org.sonar.sslr.parser.ParseErrorFormatter;
import org.sonar.sslr.parser.ParseRunner;
import org.sonar.sslr.parser.ParsingResult;
import org.sonar.sslr.tests.ParsingResultComparisonFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleAssert
extends GenericAssert<RuleAssert, Rule> {
    public RuleAssert(Rule actual) {
        super(RuleAssert.class, (Object)actual);
    }

    private ParseRunner createParseRunner() {
        this.isNotNull();
        GrammarElementMatcher endOfInput = new GrammarElementMatcher("end of input").is(new Object[]{GrammarOperators.endOfInput()});
        GrammarElementMatcher matcher = new GrammarElementMatcher(this.getRuleName() + " with end of input").is(new Object[]{this.actual, endOfInput});
        return new ParseRunner((Rule)matcher);
    }

    public RuleAssert matches(String input) {
        ParseRunner parseRunner = this.createParseRunner();
        ParsingResult parsingResult = parseRunner.parse(input.toCharArray());
        if (!parsingResult.isMatched()) {
            String expected = "Rule '" + this.getRuleName() + "' should match:\n" + input;
            String actual = new ParseErrorFormatter().format(parsingResult.getParseError());
            throw new ParsingResultComparisonFailure(expected, actual);
        }
        return this;
    }

    public RuleAssert notMatches(String input) {
        ParseRunner parseRunner = this.createParseRunner();
        ParsingResult parsingResult = parseRunner.parse(input.toCharArray());
        if (parsingResult.isMatched()) {
            throw new AssertionError((Object)("Rule '" + this.getRuleName() + "' should not match:\n" + input));
        }
        return this;
    }

    private String getRuleName() {
        return ((GrammarElementMatcher)this.actual).getName();
    }
}

