/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.confluence;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.swizzle.confluence.ObjectConvertor;
import org.codehaus.swizzle.confluence.SwizzleConversionException;

public class MapConvertor {
    private ObjectConvertor oc;

    public MapConvertor(ObjectConvertor oc) {
        this.oc = oc;
    }

    public Map convert(Map source) {
        HashMap result = new HashMap(source.size());
        Iterator i = source.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = source.get(key);
            if (value != null) {
                result.put(key, this.oc.convert(value));
                continue;
            }
            result.put(key, null);
        }
        return result;
    }

    public Map revert(Map source, Map typeMap) throws SwizzleConversionException {
        HashMap result = new HashMap(source.size());
        Iterator i = source.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = source.get(key);
            if (value != null) {
                Class type = (Class)typeMap.get(key);
                if (type == null) continue;
                result.put(key, this.oc.revert(value, type));
                continue;
            }
            result.put(key, null);
        }
        return result;
    }
}

