/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.confluence;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MapObject {
    private static final SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mmZ"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ"), new SimpleDateFormat("yyyy-MM-dd'T'HH:mm"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyyMMdd")};
    private final Map fields;

    protected MapObject() {
        this(new HashMap());
    }

    protected MapObject(Map data) {
        this.fields = new HashMap(data);
    }

    protected String getString(String key) {
        Object o = this.fields.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return this.fromDate((Date)o);
        }
        return o.toString();
    }

    protected void setString(String key, String value) {
        this.fields.put(key, value);
    }

    protected void setInt(String key, int value) {
        this.fields.put(key, new Integer(value));
    }

    protected void setInt(String key, String value) {
        this.fields.put(key, new Integer(value));
    }

    protected int getInt(String key) {
        Object o = this.fields.get(key);
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            this.setInt(key, (String)o);
            return this.getInt(key);
        }
        if (o == null) {
            return 0;
        }
        throw new IllegalStateException("Field '" + key + "' is of unknown type: " + o.getClass().getName());
    }

    protected void setBoolean(String key, boolean value) {
        this.fields.put(key, new Boolean(value));
    }

    protected void setBoolean(String key, String value) {
        boolean b = value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes");
        this.setBoolean(key, b);
    }

    protected boolean getBoolean(String key) {
        Object o = this.fields.get(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            this.setBoolean(key, (String)o);
            return this.getBoolean(key);
        }
        if (o == null) {
            return false;
        }
        throw new IllegalStateException("Field '" + key + "' is of unknown type: " + o.getClass().getName());
    }

    protected void setDate(String key, Date value) {
        this.fields.put(key, value);
    }

    protected void setDate(String key, String value) {
        this.fields.put(key, this.toDate(value));
    }

    protected Date getDate(String key) {
        Object o = this.fields.get(key);
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof String) {
            this.setDate(key, (String)o);
            return this.getDate(key);
        }
        if (o == null) {
            return null;
        }
        throw new IllegalStateException("Field '" + key + "' is of unknown type: " + o.getClass().getName());
    }

    private String fromDate(Date value) {
        return formats[0].format(value);
    }

    private Date toDate(String value) {
        if (value == null || value.equals("")) {
            return new Date();
        }
        Throwable notParsable = null;
        for (int i = 0; i < formats.length; ++i) {
            try {
                return formats[i].parse(value);
            }
            catch (ParseException e) {
                notParsable = e;
                continue;
            }
        }
        notParsable.printStackTrace();
        return new Date();
    }

    public Map toMap() {
        HashMap<String, String> map = new HashMap<String, String>(this.fields.size());
        Iterator i = this.fields.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            map.put(key, this.getString(key));
        }
        return map;
    }

    public Map toRawMap() {
        return new HashMap(this.fields);
    }

    public String toString() {
        return this.toMap().toString();
    }
}

