/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.codehaus.swizzle.jira.BasicIssueFiller;
import org.codehaus.swizzle.jira.Component;
import org.codehaus.swizzle.jira.Filter;
import org.codehaus.swizzle.jira.Issue;
import org.codehaus.swizzle.jira.IssueFiller;
import org.codehaus.swizzle.jira.IssueType;
import org.codehaus.swizzle.jira.MapObject;
import org.codehaus.swizzle.jira.MapObjectList;
import org.codehaus.swizzle.jira.Priority;
import org.codehaus.swizzle.jira.Project;
import org.codehaus.swizzle.jira.ProjectFiller;
import org.codehaus.swizzle.jira.Resolution;
import org.codehaus.swizzle.jira.ServerInfo;
import org.codehaus.swizzle.jira.Status;
import org.codehaus.swizzle.jira.User;
import org.codehaus.swizzle.jira.Version;

public class Jira {
    private static Map cacheMetadata = new HashMap();
    private final XmlRpcClient client;
    private String token;
    private HashMap cache;
    private boolean autofill = true;
    private final Map issueFillers = new LinkedHashMap();
    private final Map autofillProviders = new HashMap();
    private Map callcache = new HashMap();
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$IssueType;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Component;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Priority;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Resolution;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Version;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Status;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Filter;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Issue;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Project;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$BasicIssueFiller;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$ProjectFiller;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Jira;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$Comment;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$ServerInfo;
    static /* synthetic */ Class class$org$codehaus$swizzle$jira$User;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$List;

    public Jira(String endpoint) throws MalformedURLException {
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        if (!endpoint.endsWith("/rpc/xmlrpc")) {
            endpoint = endpoint + "/rpc/xmlrpc";
        }
        XmlRpcClientConfigImpl clientConfig = new XmlRpcClientConfigImpl();
        clientConfig.setServerURL(new URL(endpoint));
        this.client = new XmlRpcClient();
        this.client.setConfig((XmlRpcClientConfig)clientConfig);
        this.cache = new HashMap();
        BasicIssueFiller basicIssueFiller = new BasicIssueFiller(this);
        basicIssueFiller.setEnabled(true);
        this.issueFillers.put("issue", basicIssueFiller);
        this.issueFillers.put("project", new ProjectFiller(this));
        this.autofillProviders.put("issue", (class$org$codehaus$swizzle$jira$BasicIssueFiller == null ? (class$org$codehaus$swizzle$jira$BasicIssueFiller = Jira.class$("org.codehaus.swizzle.jira.BasicIssueFiller")) : class$org$codehaus$swizzle$jira$BasicIssueFiller).getName());
        this.autofillProviders.put("project", (class$org$codehaus$swizzle$jira$ProjectFiller == null ? (class$org$codehaus$swizzle$jira$ProjectFiller = Jira.class$("org.codehaus.swizzle.jira.ProjectFiller")) : class$org$codehaus$swizzle$jira$ProjectFiller).getName());
        this.autofillProviders.put("voters", "org.codehaus.swizzle.jira.VotersFiller");
        this.autofillProviders.put("subtasks", "org.codehaus.swizzle.jira.SubTasksFiller");
        this.autofillProviders.put("attachments", "org.codehaus.swizzle.jira.AttachmentsFiller");
        this.autofillProviders.put("comments", "org.codehaus.swizzle.jira.CommentsFiller");
    }

    public void autofill(String scheme, boolean enabled) {
        if (!this.autofillProviders.containsKey(scheme)) {
            throw new UnsupportedOperationException("Autofill Scheme not supported: " + scheme);
        }
        IssueFiller filler = (IssueFiller)this.issueFillers.get(scheme);
        if (filler == null) {
            try {
                ClassLoader classLoader = this.getClass().getClassLoader();
                Class<?> clazz = classLoader.loadClass((String)this.autofillProviders.get(scheme));
                Constructor<?> constructor = clazz.getConstructor(class$org$codehaus$swizzle$jira$Jira == null ? (class$org$codehaus$swizzle$jira$Jira = Jira.class$("org.codehaus.swizzle.jira.Jira")) : class$org$codehaus$swizzle$jira$Jira);
                filler = (IssueFiller)constructor.newInstance(this);
                this.issueFillers.put(scheme, filler);
            }
            catch (Exception e) {
                System.err.println("Cannot install autofill provider " + scheme);
                e.printStackTrace();
            }
        }
        filler.setEnabled(enabled);
    }

    public void login(String username, String password) throws Exception {
        this.token = (String)this.call("login", username, password);
    }

    public boolean logout() throws Exception {
        this.cache.clear();
        Boolean value = (Boolean)this.call("logout");
        return value;
    }

    public List getComments(String issueKey) {
        return this.cachedList(new Call("getComments", issueKey), class$org$codehaus$swizzle$jira$Comment == null ? (class$org$codehaus$swizzle$jira$Comment = Jira.class$("org.codehaus.swizzle.jira.Comment")) : class$org$codehaus$swizzle$jira$Comment);
    }

    public List getComments(Issue issue) {
        return this.getComments(issue.getKey());
    }

    public boolean addComment(String issueKey, String comment) throws Exception {
        Boolean value = (Boolean)this.call("getComments", issueKey, comment);
        return value;
    }

    public Issue createIssue(Issue issue) throws Exception {
        Map data = (Map)this.call("createIssue", issue.toMap());
        return this.autofill ? this.fill(new Issue(data)) : new Issue(data);
    }

    public Issue updateIssue(String issueKey, Issue issue) throws Exception {
        Map data = (Map)this.call("updateIssue", issueKey, issue.toMap());
        return this.autofill ? this.fill(new Issue(data)) : new Issue(data);
    }

    public Issue getIssue(String issueKey) {
        return (Issue)this.cachedObject(new Call("getIssue", issueKey), class$org$codehaus$swizzle$jira$Issue == null ? (class$org$codehaus$swizzle$jira$Issue = Jira.class$("org.codehaus.swizzle.jira.Issue")) : class$org$codehaus$swizzle$jira$Issue);
    }

    public List getIssuesFromFilter(Filter filter) throws Exception {
        return this.getIssuesFromFilter(filter.getId());
    }

    public List getIssuesFromFilter(String filterName) throws Exception {
        Filter filter = this.getSavedFilter(filterName);
        if (filter == null) {
            return this.toList(new Object[]{}, class$org$codehaus$swizzle$jira$Issue == null ? (class$org$codehaus$swizzle$jira$Issue = Jira.class$("org.codehaus.swizzle.jira.Issue")) : class$org$codehaus$swizzle$jira$Issue);
        }
        return this.getIssuesFromFilter(filter.getId());
    }

    public List getIssuesFromFilter(int filterId) throws Exception {
        Object[] vector = (Object[])this.call("getIssuesFromFilter", filterId + "");
        return this.toList(vector, class$org$codehaus$swizzle$jira$Issue == null ? (class$org$codehaus$swizzle$jira$Issue = Jira.class$("org.codehaus.swizzle.jira.Issue")) : class$org$codehaus$swizzle$jira$Issue);
    }

    public List getIssuesFromTextSearch(String searchTerms) throws Exception {
        Object[] vector = (Object[])this.call("getIssuesFromTextSearch", searchTerms);
        return this.toList(vector, class$org$codehaus$swizzle$jira$Issue == null ? (class$org$codehaus$swizzle$jira$Issue = Jira.class$("org.codehaus.swizzle.jira.Issue")) : class$org$codehaus$swizzle$jira$Issue);
    }

    public List getIssuesFromTextSearchWithProject(List projectKeys, String searchTerms, int maxNumResults) throws Exception {
        Object[] vector = (Object[])this.call("getIssuesFromTextSearchWithProject", projectKeys.toArray(), searchTerms, new Integer(maxNumResults));
        return this.toList(vector, class$org$codehaus$swizzle$jira$Issue == null ? (class$org$codehaus$swizzle$jira$Issue = Jira.class$("org.codehaus.swizzle.jira.Issue")) : class$org$codehaus$swizzle$jira$Issue);
    }

    public List getIssueTypes() {
        return this.cachedList(new Call("getIssueTypes"), class$org$codehaus$swizzle$jira$IssueType == null ? (class$org$codehaus$swizzle$jira$IssueType = Jira.class$("org.codehaus.swizzle.jira.IssueType")) : class$org$codehaus$swizzle$jira$IssueType);
    }

    public IssueType getIssueType(String name) {
        Map objects = this.cachedMap(new Call("getIssueTypes"), class$org$codehaus$swizzle$jira$IssueType == null ? (class$org$codehaus$swizzle$jira$IssueType = Jira.class$("org.codehaus.swizzle.jira.IssueType")) : class$org$codehaus$swizzle$jira$IssueType, "name");
        return (IssueType)objects.get(name);
    }

    public IssueType getIssueType(int id) {
        Map objects = this.cachedMap(new Call("getIssueTypes"), class$org$codehaus$swizzle$jira$IssueType == null ? (class$org$codehaus$swizzle$jira$IssueType = Jira.class$("org.codehaus.swizzle.jira.IssueType")) : class$org$codehaus$swizzle$jira$IssueType, "id");
        return (IssueType)objects.get(id + "");
    }

    public List getPriorities() {
        return this.cachedList(new Call("getPriorities"), class$org$codehaus$swizzle$jira$Priority == null ? (class$org$codehaus$swizzle$jira$Priority = Jira.class$("org.codehaus.swizzle.jira.Priority")) : class$org$codehaus$swizzle$jira$Priority);
    }

    public Priority getPriority(String name) {
        Map objects = this.cachedMap(new Call("getPriorities"), class$org$codehaus$swizzle$jira$Priority == null ? (class$org$codehaus$swizzle$jira$Priority = Jira.class$("org.codehaus.swizzle.jira.Priority")) : class$org$codehaus$swizzle$jira$Priority, "name");
        return (Priority)objects.get(name);
    }

    public Priority getPriority(int id) {
        Map objects = this.cachedMap(new Call("getPriorities"), class$org$codehaus$swizzle$jira$Priority == null ? (class$org$codehaus$swizzle$jira$Priority = Jira.class$("org.codehaus.swizzle.jira.Priority")) : class$org$codehaus$swizzle$jira$Priority, "id");
        return (Priority)objects.get(id + "");
    }

    public List getProjects() {
        return this.cachedList(new Call("getProjects"), class$org$codehaus$swizzle$jira$Project == null ? (class$org$codehaus$swizzle$jira$Project = Jira.class$("org.codehaus.swizzle.jira.Project")) : class$org$codehaus$swizzle$jira$Project);
    }

    public Project getProject(String key) {
        Map objects = this.cachedMap(new Call("getProjects"), class$org$codehaus$swizzle$jira$Project == null ? (class$org$codehaus$swizzle$jira$Project = Jira.class$("org.codehaus.swizzle.jira.Project")) : class$org$codehaus$swizzle$jira$Project, "key");
        return (Project)objects.get(key);
    }

    public Project getProject(int id) {
        Map objects = this.cachedMap(new Call("getProjects"), class$org$codehaus$swizzle$jira$Project == null ? (class$org$codehaus$swizzle$jira$Project = Jira.class$("org.codehaus.swizzle.jira.Project")) : class$org$codehaus$swizzle$jira$Project, "id");
        return (Project)objects.get(id + "");
    }

    public List getResolutions() {
        return this.cachedList(new Call("getResolutions"), class$org$codehaus$swizzle$jira$Resolution == null ? (class$org$codehaus$swizzle$jira$Resolution = Jira.class$("org.codehaus.swizzle.jira.Resolution")) : class$org$codehaus$swizzle$jira$Resolution);
    }

    public Resolution getResolution(String name) {
        Map objects = this.cachedMap(new Call("getResolutions"), class$org$codehaus$swizzle$jira$Resolution == null ? (class$org$codehaus$swizzle$jira$Resolution = Jira.class$("org.codehaus.swizzle.jira.Resolution")) : class$org$codehaus$swizzle$jira$Resolution, "name");
        return (Resolution)objects.get(name);
    }

    public Resolution getResolution(int id) {
        Map objects = this.cachedMap(new Call("getResolutions"), class$org$codehaus$swizzle$jira$Resolution == null ? (class$org$codehaus$swizzle$jira$Resolution = Jira.class$("org.codehaus.swizzle.jira.Resolution")) : class$org$codehaus$swizzle$jira$Resolution, "id");
        return (Resolution)objects.get(id + "");
    }

    public List getStatuses() {
        return this.cachedList(new Call("getStatuses"), class$org$codehaus$swizzle$jira$Status == null ? (class$org$codehaus$swizzle$jira$Status = Jira.class$("org.codehaus.swizzle.jira.Status")) : class$org$codehaus$swizzle$jira$Status);
    }

    public Status getStatus(String name) {
        Map objects = this.cachedMap(new Call("getStatuses"), class$org$codehaus$swizzle$jira$Status == null ? (class$org$codehaus$swizzle$jira$Status = Jira.class$("org.codehaus.swizzle.jira.Status")) : class$org$codehaus$swizzle$jira$Status, "name");
        return (Status)objects.get(name);
    }

    public Status getStatus(int id) {
        Map objects = this.cachedMap(new Call("getStatuses"), class$org$codehaus$swizzle$jira$Status == null ? (class$org$codehaus$swizzle$jira$Status = Jira.class$("org.codehaus.swizzle.jira.Status")) : class$org$codehaus$swizzle$jira$Status, "id");
        return (Status)objects.get(id + "");
    }

    public List getSavedFilters() {
        return this.cachedList(new Call("getSavedFilters"), class$org$codehaus$swizzle$jira$Filter == null ? (class$org$codehaus$swizzle$jira$Filter = Jira.class$("org.codehaus.swizzle.jira.Filter")) : class$org$codehaus$swizzle$jira$Filter);
    }

    public Filter getSavedFilter(String name) {
        Map objects = this.cachedMap(new Call("getSavedFilters"), class$org$codehaus$swizzle$jira$Filter == null ? (class$org$codehaus$swizzle$jira$Filter = Jira.class$("org.codehaus.swizzle.jira.Filter")) : class$org$codehaus$swizzle$jira$Filter, "name");
        return (Filter)objects.get(name);
    }

    public Filter getSavedFilter(int id) {
        Map objects = this.cachedMap(new Call("getSavedFilters"), class$org$codehaus$swizzle$jira$Filter == null ? (class$org$codehaus$swizzle$jira$Filter = Jira.class$("org.codehaus.swizzle.jira.Filter")) : class$org$codehaus$swizzle$jira$Filter, "id");
        return (Filter)objects.get(id + "");
    }

    public ServerInfo getServerInfo() {
        return (ServerInfo)this.cachedObject(new Call("getServerInfo"), class$org$codehaus$swizzle$jira$ServerInfo == null ? (class$org$codehaus$swizzle$jira$ServerInfo = Jira.class$("org.codehaus.swizzle.jira.ServerInfo")) : class$org$codehaus$swizzle$jira$ServerInfo);
    }

    public List getSubTaskIssueTypes() {
        return this.cachedList(new Call("getSubTaskIssueTypes"), class$org$codehaus$swizzle$jira$IssueType == null ? (class$org$codehaus$swizzle$jira$IssueType = Jira.class$("org.codehaus.swizzle.jira.IssueType")) : class$org$codehaus$swizzle$jira$IssueType);
    }

    public IssueType getSubTaskIssueType(String name) {
        Map objects = this.cachedMap(new Call("getSubTaskIssueTypes"), class$org$codehaus$swizzle$jira$IssueType == null ? (class$org$codehaus$swizzle$jira$IssueType = Jira.class$("org.codehaus.swizzle.jira.IssueType")) : class$org$codehaus$swizzle$jira$IssueType, "name");
        return (IssueType)objects.get(name);
    }

    public IssueType getSubTaskIssueType(int id) {
        Map objects = this.cachedMap(new Call("getSubTaskIssueTypes"), class$org$codehaus$swizzle$jira$IssueType == null ? (class$org$codehaus$swizzle$jira$IssueType = Jira.class$("org.codehaus.swizzle.jira.IssueType")) : class$org$codehaus$swizzle$jira$IssueType, "id");
        return (IssueType)objects.get(id + "");
    }

    public User getUser(String username) {
        return (User)this.cachedObject(new Call("getUser", username), class$org$codehaus$swizzle$jira$User == null ? (class$org$codehaus$swizzle$jira$User = Jira.class$("org.codehaus.swizzle.jira.User")) : class$org$codehaus$swizzle$jira$User);
    }

    public List getComponents(String projectKey) {
        return this.cachedList(new Call("getComponents", projectKey), class$org$codehaus$swizzle$jira$Component == null ? (class$org$codehaus$swizzle$jira$Component = Jira.class$("org.codehaus.swizzle.jira.Component")) : class$org$codehaus$swizzle$jira$Component);
    }

    public List getComponents(Project project) {
        return this.getComments(project.getKey());
    }

    public Component getComponent(String projectKey, String name) {
        Map components = this.cachedMap(new Call("getComponents", projectKey), class$org$codehaus$swizzle$jira$Component == null ? (class$org$codehaus$swizzle$jira$Component = Jira.class$("org.codehaus.swizzle.jira.Component")) : class$org$codehaus$swizzle$jira$Component, "name");
        return (Component)components.get(name);
    }

    public Component getComponent(Project project, String name) {
        return this.getComponent(project.getKey(), name);
    }

    public Component getComponent(String projectKey, int id) {
        Map components = this.cachedMap(new Call("getComponents", projectKey), class$org$codehaus$swizzle$jira$Component == null ? (class$org$codehaus$swizzle$jira$Component = Jira.class$("org.codehaus.swizzle.jira.Component")) : class$org$codehaus$swizzle$jira$Component, "id");
        return (Component)components.get(id + "");
    }

    public Component getComponent(Project project, int id) {
        return this.getComponent(project.getKey(), id);
    }

    public List getVersions(String projectKey) {
        return this.cachedList(new Call("getVersions", projectKey), class$org$codehaus$swizzle$jira$Version == null ? (class$org$codehaus$swizzle$jira$Version = Jira.class$("org.codehaus.swizzle.jira.Version")) : class$org$codehaus$swizzle$jira$Version);
    }

    public List getVersions(Project project) {
        return this.getVersions(project.getKey());
    }

    public Version getVersion(String projectKey, String name) {
        Map versions = this.cachedMap(new Call("getVersions", projectKey), class$org$codehaus$swizzle$jira$Version == null ? (class$org$codehaus$swizzle$jira$Version = Jira.class$("org.codehaus.swizzle.jira.Version")) : class$org$codehaus$swizzle$jira$Version, "name");
        return (Version)versions.get(name);
    }

    public Version getVersion(Project project, String name) {
        return this.getVersion(project.getKey(), name);
    }

    public Version getVersion(String projectKey, int id) {
        Map versions = this.cachedMap(new Call("getVersions", projectKey), class$org$codehaus$swizzle$jira$Version == null ? (class$org$codehaus$swizzle$jira$Version = Jira.class$("org.codehaus.swizzle.jira.Version")) : class$org$codehaus$swizzle$jira$Version, "id");
        return (Version)versions.get(id + "");
    }

    public Version getVersion(Project project, int id) {
        return this.getVersion(project.getKey(), id);
    }

    private List toList(Object[] vector, Class type) {
        MapObjectList list = new MapObjectList(vector.length);
        try {
            Constructor constructor = type.getConstructor(class$java$util$Map == null ? (class$java$util$Map = Jira.class$("java.util.Map")) : class$java$util$Map);
            for (int i = 0; i < vector.length; ++i) {
                Map data = (Map)vector[i];
                Object object = constructor.newInstance(data);
                this.fill(type, object);
                list.add(object);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    private void fill(Class type, Object object) {
        if (this.autofill && type == (class$org$codehaus$swizzle$jira$Issue == null ? (class$org$codehaus$swizzle$jira$Issue = Jira.class$("org.codehaus.swizzle.jira.Issue")) : class$org$codehaus$swizzle$jira$Issue)) {
            this.fill((Issue)object);
        }
        if (type == (class$org$codehaus$swizzle$jira$Filter == null ? (class$org$codehaus$swizzle$jira$Filter = Jira.class$("org.codehaus.swizzle.jira.Filter")) : class$org$codehaus$swizzle$jira$Filter)) {
            Filter filter = (Filter)object;
            User dest = filter.getAuthor();
            User source = this.getUser(dest.getName());
            dest.merge(source);
        }
    }

    private Object toObject(Map data, Class type) {
        try {
            Constructor constructor = type.getConstructor(class$java$util$Map == null ? (class$java$util$Map = Jira.class$("java.util.Map")) : class$java$util$Map);
            Object object = constructor.newInstance(data);
            this.fill(type, object);
            return object;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object call(String command) throws Exception {
        Object[] args = new Object[]{};
        return this.call(command, args);
    }

    private Object call(String command, Object arg1) throws Exception {
        Object[] args = new Object[]{arg1};
        return this.call(command, args);
    }

    private Object call(String command, Object arg1, Object arg2) throws Exception {
        Object[] args = new Object[]{arg1, arg2};
        return this.call(command, args);
    }

    private Object call(String command, Object arg1, Object arg2, Object arg3) throws Exception {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return this.call(command, args);
    }

    private Object call(String command, Object[] args) throws XmlRpcException, IOException {
        Object[] vector;
        if (this.token != null) {
            vector = new Object[args.length + 1];
            vector[0] = this.token;
            System.arraycopy(args, 0, vector, 1, args.length);
        } else {
            vector = args;
        }
        return this.client.execute("jira1." + command, vector);
    }

    public Issue fill(Issue issue) {
        Collection collection = this.issueFillers.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IssueFiller issueFiller = (IssueFiller)iterator.next();
            issueFiller.fill(issue);
        }
        return issue;
    }

    private List cachedList(Call call, Class type) {
        Object result = this.cache(call, type);
        Map indexes = (Map)result;
        return (List)indexes.get(class$java$util$List == null ? (class$java$util$List = Jira.class$("java.util.List")) : class$java$util$List);
    }

    private Map cachedMap(Call call, Class type, String field) {
        Object result = this.cache(call, type);
        Map indexes = (Map)result;
        return (Map)indexes.get(field);
    }

    private Object cachedObject(Call call, Class type) {
        return this.cache(call, type);
    }

    private Object cache(Call call, Class type) {
        Object object = this.callcache.get(call);
        if (object != null) {
            return object;
        }
        HashMap<Object, Cloneable> result = this.exec(call);
        if (result instanceof Object[]) {
            List list = this.toList((Object[])result, type);
            HashMap<Object, Cloneable> indexes = new HashMap<Object, Cloneable>();
            String[] uniqueFields = (String[])cacheMetadata.get(type);
            for (int i = 0; uniqueFields != null && i < uniqueFields.length; ++i) {
                HashMap<String, MapObject> index = new HashMap<String, MapObject>();
                String field = uniqueFields[i];
                for (int j = 0; j < list.size(); ++j) {
                    MapObject mapObject = (MapObject)list.get(j);
                    index.put(mapObject.getString(field), mapObject);
                }
                indexes.put(field, index);
            }
            indexes.put(class$java$util$List == null ? (class$java$util$List = Jira.class$("java.util.List")) : class$java$util$List, new MapObjectList((Collection)list));
            result = indexes;
        } else if (result instanceof Map) {
            result = this.toObject(result, type);
        }
        this.callcache.put(call, result);
        return result;
    }

    private Object exec(Call call) {
        try {
            Object[] vector;
            if (this.token != null) {
                vector = new Object[call.args.length + 1];
                vector[0] = this.token;
                System.arraycopy(call.args, 0, vector, 1, call.args.length);
            } else {
                vector = call.args;
            }
            return this.client.execute("jira1." + call.command, vector);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        cacheMetadata.put(class$org$codehaus$swizzle$jira$IssueType == null ? (class$org$codehaus$swizzle$jira$IssueType = Jira.class$("org.codehaus.swizzle.jira.IssueType")) : class$org$codehaus$swizzle$jira$IssueType, new String[]{"id", "name"});
        cacheMetadata.put(class$org$codehaus$swizzle$jira$Component == null ? (class$org$codehaus$swizzle$jira$Component = Jira.class$("org.codehaus.swizzle.jira.Component")) : class$org$codehaus$swizzle$jira$Component, new String[]{"id", "name"});
        cacheMetadata.put(class$org$codehaus$swizzle$jira$Priority == null ? (class$org$codehaus$swizzle$jira$Priority = Jira.class$("org.codehaus.swizzle.jira.Priority")) : class$org$codehaus$swizzle$jira$Priority, new String[]{"id", "name"});
        cacheMetadata.put(class$org$codehaus$swizzle$jira$Resolution == null ? (class$org$codehaus$swizzle$jira$Resolution = Jira.class$("org.codehaus.swizzle.jira.Resolution")) : class$org$codehaus$swizzle$jira$Resolution, new String[]{"id", "name"});
        cacheMetadata.put(class$org$codehaus$swizzle$jira$Version == null ? (class$org$codehaus$swizzle$jira$Version = Jira.class$("org.codehaus.swizzle.jira.Version")) : class$org$codehaus$swizzle$jira$Version, new String[]{"id", "name"});
        cacheMetadata.put(class$org$codehaus$swizzle$jira$Status == null ? (class$org$codehaus$swizzle$jira$Status = Jira.class$("org.codehaus.swizzle.jira.Status")) : class$org$codehaus$swizzle$jira$Status, new String[]{"id", "name"});
        cacheMetadata.put(class$org$codehaus$swizzle$jira$Filter == null ? (class$org$codehaus$swizzle$jira$Filter = Jira.class$("org.codehaus.swizzle.jira.Filter")) : class$org$codehaus$swizzle$jira$Filter, new String[]{"id", "name"});
        cacheMetadata.put(class$org$codehaus$swizzle$jira$Issue == null ? (class$org$codehaus$swizzle$jira$Issue = Jira.class$("org.codehaus.swizzle.jira.Issue")) : class$org$codehaus$swizzle$jira$Issue, new String[]{"id", "key"});
        cacheMetadata.put(class$org$codehaus$swizzle$jira$Project == null ? (class$org$codehaus$swizzle$jira$Project = Jira.class$("org.codehaus.swizzle.jira.Project")) : class$org$codehaus$swizzle$jira$Project, new String[]{"id", "key"});
    }

    public static class Call {
        public final String command;
        public final Object[] args;

        public Call(String command) {
            Object[] args = new Object[]{};
            this.command = command;
            this.args = args;
        }

        public Call(String command, Object arg1) {
            Object[] args = new Object[]{arg1};
            this.command = command;
            this.args = args;
        }

        public Call(String command, Object arg1, Object arg2) {
            Object[] args = new Object[]{arg1, arg2};
            this.command = command;
            this.args = args;
        }

        public Call(String command, Object arg1, Object arg2, Object arg3) {
            Object[] args = new Object[]{arg1, arg2, arg3};
            this.command = command;
            this.args = args;
        }

        public Call(String command, Object[] args) {
            this.command = command;
            this.args = args;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Call call = (Call)o;
            if (!Arrays.equals(this.args, call.args)) {
                return false;
            }
            return this.command.equals(call.command);
        }

        public int hashCode() {
            return this.command.hashCode();
        }
    }
}

