/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.swizzle.jira.MapObjectList;

public class MapObject {
    protected Map xmlrpcRefs = new HashMap();
    protected List xmlrpcNoSend = new ArrayList();
    protected Map attributes;
    private final SimpleDateFormat[] formats;
    protected final Map fields;
    static /* synthetic */ Class class$java$util$Map;

    protected MapObject(Map data) {
        this.fields = new HashMap(data);
        this.formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"), new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S")};
        this.attributes = new Attributes();
    }

    public Map getAttributes() {
        return this.attributes;
    }

    protected String getString(String key) {
        return (String)this.fields.get(key);
    }

    protected boolean getBoolean(String key) {
        String value = this.getString(key);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true") || value.equals("1") || value.equalsIgnoreCase("yes");
    }

    protected int getInt(String key) {
        String value = this.getString(key);
        if (value == null) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    protected void setString(String key, String value) {
        this.fields.put(key, value);
    }

    protected void setInt(String key, int value) {
        this.fields.put(key, Integer.toString(value));
    }

    protected void setBoolean(String key, boolean value) {
        this.fields.put(key, Boolean.toString(value));
    }

    protected void setUrl(String key, URL url) {
        this.fields.put(key, url == null ? null : url.toExternalForm());
    }

    protected URL getUrl(String key) {
        try {
            String value = this.getString(key);
            return value == null ? null : new URL(value);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected void setDate(String key, Date value) {
        this.fields.put(key, this.formats[0].format(value));
    }

    protected Date getDate(String key) {
        String value = this.getString(key);
        if (value == null || value.equals("")) {
            return new Date();
        }
        Throwable notParsable = null;
        for (int i = 0; i < this.formats.length; ++i) {
            try {
                return this.formats[i].parse(value);
            }
            catch (ParseException e) {
                notParsable = e;
                continue;
            }
        }
        notParsable.printStackTrace();
        return new Date();
    }

    protected List getList(String key) {
        return (List)this.fields.get(key);
    }

    protected void setList(String key, List value) {
        this.fields.put(key, value);
    }

    protected MapObject getMapObject(String key, Class type) {
        Object object = this.fields.get(key);
        if (object == null) {
            return null;
        }
        if (object instanceof MapObject) {
            return (MapObject)object;
        }
        try {
            MapObject mapObject = this.createMapObject(type, object);
            this.fields.put(key, mapObject);
            return mapObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void setMapObject(String key, MapObject mapObject) {
        this.fields.put(key, mapObject);
    }

    protected boolean hasField(String key) {
        return this.fields.containsKey(key);
    }

    protected List getMapObjects(String key, Class type) {
        List list;
        Object collection = this.fields.get(key);
        if (collection instanceof Object[]) {
            Object[] vector = (Object[])collection;
            try {
                list = this.toList(vector, type);
                this.fields.put(key, list);
            }
            catch (Exception e) {
                list = new MapObjectList();
            }
        } else if (collection == null) {
            list = new MapObjectList();
            this.fields.put(key, list);
        } else {
            list = (List)collection;
        }
        return list;
    }

    protected void setMapObjects(String key, List objects) {
        this.fields.put(key, objects);
    }

    protected List toList(Object[] vector, Class type) throws Exception {
        MapObjectList list = new MapObjectList(vector.length);
        for (int i = 0; i < vector.length; ++i) {
            MapObject object = this.createMapObject(type, vector[i]);
            list.add(object);
        }
        return list;
    }

    private MapObject createMapObject(Class type, Object value) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        HashMap data;
        Constructor constructor = type.getConstructor(class$java$util$Map == null ? (class$java$util$Map = MapObject.class$("java.util.Map")) : class$java$util$Map);
        Object idField = this.xmlrpcRefs.get(type);
        if (idField != null && !(value instanceof Map)) {
            data = new HashMap();
            data.put(idField, value);
        } else if (value instanceof Map) {
            data = (HashMap)value;
        } else {
            throw new RuntimeException("Cannot create a " + type.getName() + " from '" + value + "'");
        }
        Object object = constructor.newInstance(data);
        return (MapObject)object;
    }

    public Map toMap() {
        Map.Entry entry;
        HashMap map = new HashMap(this.fields.size());
        Iterator i = this.fields.entrySet().iterator();
        while (i.hasNext()) {
            entry = i.next();
            if (entry.getValue() == null) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        for (int i2 = 0; i2 < this.xmlrpcNoSend.size(); ++i2) {
            String fieldName = (String)this.xmlrpcNoSend.get(i2);
            map.remove(fieldName);
        }
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof MapObject) {
                MapObject mapObject = (MapObject)value;
                map.put(key, this.toMapOrId(mapObject));
                continue;
            }
            if (!(value instanceof List) || value instanceof Object[]) continue;
            List objects = (List)value;
            Object[] vector = new Object[objects.size()];
            for (int i3 = 0; i3 < objects.size(); ++i3) {
                MapObject mapObject = (MapObject)objects.get(i3);
                vector[i3] = this.toMapOrId(mapObject);
            }
            map.put(key, vector);
        }
        return map;
    }

    private Object toMapOrId(MapObject mapObject) {
        Map child = mapObject.toMap();
        String idField = (String)this.xmlrpcRefs.get(mapObject.getClass());
        Map object = idField != null ? child.get(idField) : child;
        return object;
    }

    protected void merge(MapObject source) {
        if (source != null) {
            this.fields.putAll(source.fields);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Attributes
    implements Map {
        public Attributes() {
            MapObject.this.fields.put("#attributes", new LinkedHashMap());
            MapObject.this.xmlrpcNoSend.add("#attributes");
        }

        private Map map() {
            return (Map)MapObject.this.fields.get("#attributes");
        }

        public void clear() {
            this.map().clear();
        }

        public boolean containsKey(Object object) {
            return this.map().containsKey(object);
        }

        public boolean containsValue(Object object) {
            return this.map().containsValue(object);
        }

        public Set entrySet() {
            return this.map().entrySet();
        }

        public Object get(Object object) {
            return this.map().get(object);
        }

        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        public Set keySet() {
            return this.map().keySet();
        }

        public Object put(Object object, Object object1) {
            return this.map().put(object, object1);
        }

        public void putAll(Map context) {
            this.map().putAll(context);
        }

        public Object remove(Object object) {
            return this.map().remove(object);
        }

        public int size() {
            return this.map().size();
        }

        public Collection values() {
            return this.map().values();
        }
    }
}

