/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.jira;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.swizzle.jira.MapObject;

public class MapObjectList
extends ArrayList {
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$String;

    public MapObjectList() {
    }

    public MapObjectList(Collection collection) {
        super(collection);
    }

    public MapObjectList(int i) {
        super(i);
    }

    public Object min(String field) {
        return Collections.min(this, this.getComparator(field));
    }

    public Object max(String field) {
        return Collections.max(this, this.getComparator(field));
    }

    public List collect(String field) {
        if (this.size() == 0) {
            return this;
        }
        Accessor accessor = new Accessor(field, this);
        boolean mapObjectData = true;
        ArrayList<Object> collection = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            MapObject mapObject = (MapObject)this.get(i);
            Object value = accessor.getValue(mapObject);
            if (value instanceof List) {
                List list = (List)value;
                for (int j = 0; j < list.size(); ++j) {
                    Object object = list.get(j);
                    collection.add(object);
                    mapObjectData = mapObjectData && object instanceof MapObject;
                }
                continue;
            }
            collection.add(value);
            mapObjectData = mapObjectData && value instanceof MapObject;
        }
        if (mapObjectData) {
            return new MapObjectList(collection);
        }
        return collection;
    }

    public MapObjectList unique(String field) {
        if (this.size() == 0) {
            return this;
        }
        Accessor accessor = new Accessor(field, this);
        MapObjectList subset = new MapObjectList();
        ArrayList<Object> uniqueList = new ArrayList<Object>();
        for (int i = 0; i < this.size(); ++i) {
            MapObject mapObject = (MapObject)this.get(i);
            Object value = accessor.getValue(mapObject);
            if (uniqueList.contains(value)) continue;
            uniqueList.add(value);
            subset.add(mapObject);
        }
        return subset;
    }

    public MapObjectList union(List list) {
        MapObjectList difference = new MapObjectList((Collection)this);
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (this.contains(object)) continue;
            difference.add(object);
        }
        return difference;
    }

    public MapObjectList intersection(List list) {
        MapObjectList common = new MapObjectList();
        for (int i = 0; i < this.size(); ++i) {
            Object object = this.get(i);
            if (!list.contains(object)) continue;
            common.add(object);
        }
        return common;
    }

    public MapObjectList common(List list) {
        return this.intersection(list);
    }

    public MapObjectList subtract(List list) {
        MapObjectList subtract = new MapObjectList((Collection)this);
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            subtract.remove(object);
        }
        return subtract;
    }

    public MapObjectList difference(List list) {
        MapObjectList difference = new MapObjectList((Collection)this);
        for (int i = 0; i < list.size(); ++i) {
            Object object = list.get(i);
            if (this.contains(object)) {
                difference.remove(object);
                continue;
            }
            difference.add(object);
        }
        return difference;
    }

    public int sum(String field) {
        if (this.size() == 0) {
            return 0;
        }
        int sum = 0;
        Accessor accessor = new Accessor(field, this);
        for (int i = 0; i < this.size(); ++i) {
            try {
                MapObject mapObject = (MapObject)this.get(i);
                sum += accessor.intValue(mapObject);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return sum;
    }

    public int average(String field) {
        if (this.size() == 0) {
            return 0;
        }
        int sum = 0;
        Accessor accessor = new Accessor(field, this);
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            try {
                MapObject mapObject = (MapObject)this.get(i);
                sum += accessor.intValue(mapObject);
                ++count;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return sum == 0 ? sum : sum / count;
    }

    public MapObjectList contains(String field, String string) {
        if (this.size() == 0) {
            return this;
        }
        Accessor accessor = new Accessor(field, this);
        MapObjectList subset = new MapObjectList();
        for (int i = 0; i < this.size(); ++i) {
            MapObject mapObject = (MapObject)this.get(i);
            String value = accessor.stringValue(mapObject);
            if (value == null || value.indexOf(string) == -1) continue;
            subset.add(mapObject);
        }
        return subset;
    }

    public MapObjectList matches(String field, String string) {
        if (this.size() == 0) {
            return this;
        }
        Pattern pattern = Pattern.compile(string);
        Accessor accessor = new Accessor(field, this);
        MapObjectList subset = new MapObjectList();
        for (int i = 0; i < this.size(); ++i) {
            MapObject mapObject = (MapObject)this.get(i);
            String value = accessor.stringValue(mapObject);
            if (value == null || !pattern.matcher(value).matches()) continue;
            subset.add(mapObject);
        }
        return subset;
    }

    public MapObjectList equals(String field, String string) {
        if (this.size() == 0) {
            return this;
        }
        Accessor accessor = new Accessor(field, this);
        MapObjectList subset = new MapObjectList();
        for (int i = 0; i < this.size(); ++i) {
            MapObject mapObject = (MapObject)this.get(i);
            String value = accessor.stringValue(mapObject);
            if (value == null || !value.equals(string)) continue;
            subset.add(mapObject);
        }
        return subset;
    }

    public MapObjectList greater(String field, String string) {
        return this.compareAndCollect(field, string, 1);
    }

    public MapObjectList less(String field, String string) {
        return this.compareAndCollect(field, string, -1);
    }

    public MapObjectList greater(String field, Object object) {
        return this.compareAndCollect(field, object, 1);
    }

    public MapObjectList less(String field, Object object) {
        return this.compareAndCollect(field, object, -1);
    }

    public MapObjectList ascending(String field) {
        return this.sort(field);
    }

    public MapObjectList descending(String field) {
        return this.sort(field, true);
    }

    public MapObjectList sort(String field) {
        return this.sort(field, false);
    }

    public MapObjectList sort(String field, boolean reverse) {
        if (this.size() == 0) {
            return this;
        }
        Comparator comparator = this.getComparator(field);
        comparator = reverse ? new ReverseComparator(comparator) : comparator;
        MapObjectList list = new MapObjectList((Collection)this);
        Collections.sort(list, comparator);
        return list;
    }

    private MapObjectList compareAndCollect(String field, Object data, int condition) {
        if (this.size() == 0) {
            return this;
        }
        try {
            Object base;
            Constructor<?> constructor;
            Class<?> type = this.get(0).getClass();
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (field.startsWith("@")) {
                constructor = type.getConstructor(class$java$util$Map == null ? (class$java$util$Map = MapObjectList.class$("java.util.Map")) : class$java$util$Map);
                base = constructor.newInstance(map);
                ((MapObject)base).getAttributes().put(field.replaceFirst("^@", ""), data);
            } else {
                map.put(field, data);
                constructor = type.getConstructor(class$java$util$Map == null ? (class$java$util$Map = MapObjectList.class$("java.util.Map")) : class$java$util$Map);
                base = constructor.newInstance(map);
            }
            Comparator comparator = this.getComparator(field);
            MapObjectList subset = new MapObjectList();
            for (int i = 0; i < this.size(); ++i) {
                Object object = this.get(i);
                int value = comparator.compare(object, base);
                if (value / condition <= 0) continue;
                subset.add(object);
            }
            return subset;
        }
        catch (Exception e) {
            return new MapObjectList();
        }
    }

    private Comparator getComparator(String field) {
        return new FieldComparator(new Accessor(field, this));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Accessor {
        private final String field;
        private final Method method;
        private final boolean isAttribute;

        public Accessor(String field, List list) {
            this.isAttribute = field.startsWith("@");
            this.field = this.isAttribute ? field.replaceFirst("^@", "") : field;
            this.method = !this.isAttribute ? this.method(list, field) : null;
        }

        private Method method(List list, String field) {
            Method method = null;
            try {
                MapObject first = (MapObject)list.get(0);
                StringBuffer sb = new StringBuffer(field);
                sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
                method = first.getClass().getMethod("get" + sb, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return method;
        }

        public Object getValue(MapObject mapObject) {
            try {
                if (this.method != null) {
                    return this.method.invoke((Object)mapObject, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.map(mapObject).get(this.field);
        }

        private Map map(MapObject mapObject) {
            return this.isAttribute ? mapObject.getAttributes() : mapObject.fields;
        }

        public int intValue(MapObject mapObject) throws NumberFormatException {
            Object value = this.getValue(mapObject);
            if (value instanceof Number) {
                Number number = (Number)value;
                return number.intValue();
            }
            return new Integer(value.toString());
        }

        public String stringValue(MapObject mapObject) {
            Object value = this.method != null && this.method.getReturnType() == (class$java$lang$String == null ? (class$java$lang$String = MapObjectList.class$("java.lang.String")) : class$java$lang$String) ? this.map(mapObject).get(this.field) : this.getValue(mapObject);
            return value == null ? null : value.toString();
        }

        public String getField() {
            return this.field;
        }

        public Method getMethod() {
            return this.method;
        }
    }

    private static class FieldComparator
    implements Comparator {
        private final Accessor accessor;

        public FieldComparator(Accessor accessor) {
            this.accessor = accessor;
        }

        public int compare(Object objectA, Object objectB) {
            try {
                Object a = this.accessor.getValue((MapObject)objectA);
                Object b = this.accessor.getValue((MapObject)objectB);
                if (a instanceof Comparable) {
                    return ((Comparable)a).compareTo(b);
                }
                return a.toString().compareTo(b.toString());
            }
            catch (Exception e) {
                return 0;
            }
        }
    }

    private static class ReverseComparator
    implements Comparator {
        private final Comparator comparator;

        public ReverseComparator(Comparator comparator) {
            this.comparator = comparator;
        }

        public int compare(Object a, Object b) {
            return -1 * this.comparator.compare(a, b);
        }
    }
}

